package net.doo.snap.lib.snap.camera;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;

import net.doo.snap.lib.snap.util.Utils;

import java.util.Arrays;
import java.util.Collection;

/**
 * Modified {@link net.doo.snap.lib.snap.camera.SnapCameraHost} with custom-ROMs specific behavior.
 */
public class CustomROMCameraHost extends SnapCameraHost {

    /*
     Those Samsung devices with custom ROMs are prone to camera errors due to bug in camera driver.
     For them we'll need to provide preview size with the same aspect ratio as picture size have
     */
    private static final Collection<String> KEEP_ASPECT_RATIO_PRODUCT_NAMES = Arrays.asList("m0xx", "m3xx", "t0ltespr");

    public CustomROMCameraHost(Context context) {
        super(context);
    }

    @Override
    protected Camera.Size findPreviewSize(int displayOrientation, int width, int height, Camera.Parameters parameters) {
        if (KEEP_ASPECT_RATIO_PRODUCT_NAMES.contains(Build.PRODUCT)) {
            Camera.Size pictureSize = Utils.getLargestPictureSize(parameters);
            return Utils.getLargestSizeWithAspectRatioMatch(parameters.getSupportedPreviewSizes(), pictureSize.width / (double) pictureSize.height);
        } else {
            return super.findPreviewSize(displayOrientation, width, height, parameters);
        }
    }

    @Override
    public byte[] getNewPreviewBuffer() {
        return null;
    }
}
