package net.doo.snap.lib.snap.edit.drag;

import android.graphics.Bitmap;

import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.snap.ImagePreviewFragment;

/**
 * Contains information about performed drag
 */
public class DragLocalState {

    private final ImagePreviewFragment draggedFragment;
    private final Bitmap preservedBitmap;
    private final Page page;
    private final int pagePosition;

    public DragLocalState(ImagePreviewFragment draggedFragment, Bitmap preservedBitmap, Page page, int pagePosition) {
        this.draggedFragment = draggedFragment;
        this.preservedBitmap = preservedBitmap;
        this.page = page;
        this.pagePosition = pagePosition;
    }

    /**
     * @return {@link net.doo.snap.lib.snap.ImagePreviewFragment} which initiated drag
     */
    public ImagePreviewFragment getDraggedFragment() {
        return draggedFragment;
    }

    /**
     * @return {@link android.graphics.Bitmap} which was used by {@link net.doo.snap.lib.snap.ImagePreviewFragment}
     */
    public Bitmap getPreservedBitmap() {
        return preservedBitmap;
    }

    /**
     * @return {@link net.doo.snap.lib.persistence.Page} being dragged
     */
    public Page getPage() {
        return page;
    }

    /**
     * @return position in document of {@link net.doo.snap.lib.persistence.Page} being dragged
     */
    public int getPagePosition() {
        return pagePosition;
    }
}
