/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.edit;

import com.google.inject.Inject;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.persistence.RotationType;
import net.doo.snap.lib.snap.ImagePreviewFragment;
import net.doo.snap.lib.snap.PreviewFragmentPagerAdapter;
import net.doo.snap.lib.snap.edit.EditLock;
import net.doo.snap.lib.snap.edit.PagesEditor;
import net.doo.snap.lib.snap.edit.events.RotatePageEvent;
import net.doo.snap.lib.ui.widget.ViewPager;
import roboguice.event.Observes;

public class RotatePageEditor
implements PagesEditor {
    private EditLock editLock;
    private ViewPager pager;
    private PreviewFragmentPagerAdapter adapter;

    @Inject
    public RotatePageEditor(EditLock editLock) {
        this.editLock = editLock;
    }

    public void attachViewPager(ViewPager viewPager, PreviewFragmentPagerAdapter adapter) {
        this.pager = viewPager;
        this.adapter = adapter;
    }

    public void onPageRotation(@Observes RotatePageEvent event) {
        if (this.editLock.isEditLocked()) {
            return;
        }
        int currentItem = this.pager.getCurrentItem();
        ImagePreviewFragment fragment = this.adapter.getFragment(this.pager, currentItem);
        Page page = this.adapter.getDocumentDraft().getPage(currentItem);
        RotationType newRotation = RotationType.rotateClockwise(page.getRotationType());
        fragment.setPageRotation(newRotation);
        page.setRotationType(newRotation);
    }
}

