package net.doo.snap.lib.analytics;

import android.app.Activity;

import com.google.inject.Inject;

import roboguice.activity.event.OnPauseEvent;
import roboguice.activity.event.OnResumeEvent;
import roboguice.activity.event.OnStartEvent;
import roboguice.activity.event.OnStopEvent;
import roboguice.event.Observes;

/**
 * Injectable class that tracks {@link android.app.Activity} lifecycle for usage in analytics
 */
public class ActivityAnalytics {

    private Activity activity;

    @Inject
    public ActivityAnalytics(Activity activity) {
        this.activity = activity;
    }

    @SuppressWarnings("unused")
    public void onStart(@Observes OnStartEvent event) {
        EasyTrackerWrapper.activityStart(activity);
    }

    @SuppressWarnings("unused")
    public void onStop(@Observes OnStopEvent event) {
        EasyTrackerWrapper.activityStop(activity);
    }

    @SuppressWarnings("unused")
    public void onResume(@Observes OnResumeEvent event) {
        EasyTrackerWrapper.activityResume(activity);
    }

    @SuppressWarnings("unused")
    public void onPause(@Observes OnPauseEvent event) {
        EasyTrackerWrapper.activityPause(activity);
    }
}
