/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Bundle;
import android.view.DragEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.inject.Inject;
import net.doo.snap.lib.snap.edit.drag.DragLocalState;
import net.doo.snap.lib.snap.edit.events.RetakePageEvent;
import roboguice.event.EventManager;
import roboguice.fragment.RoboFragment;

public class RetakePhotoDropTargetFragment
extends RoboFragment {
    private static final float DRAG_ENTER_SCALE = 1.15f;
    private static final long DRAG_ENTER_DURATION_MILLIS = 200L;
    private static final ArgbEvaluator ARGB_EVALUATOR = new ArgbEvaluator();
    @Inject
    private EventManager eventManager;
    private int defaultColor;
    private int activeColor;
    private View dropTarget;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.defaultColor = this.getResources().getColor(2131099667);
        this.activeColor = this.getResources().getColor(2131099668);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(2130903057, container, false);
        this.dropTarget = rootView.findViewById(2131165227);
        this.setupDragListener();
        return rootView;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getView().setAlpha(0.0f);
    }

    @TargetApi(value=11)
    private void setupDragListener() {
        class DragListener
        implements View.OnDragListener {
            DragListener() {
            }

            public boolean onDrag(View v, DragEvent event) {
                switch (event.getAction()) {
                    case 1: {
                        RetakePhotoDropTargetFragment.this.showDropTarget();
                        break;
                    }
                    case 5: {
                        RetakePhotoDropTargetFragment.this.animateDragEnter();
                        RetakePhotoDropTargetFragment.this.animateBackgroundDragEnter();
                        break;
                    }
                    case 6: {
                        RetakePhotoDropTargetFragment.this.animateDragExit();
                        RetakePhotoDropTargetFragment.this.animateBackgroundDragExit();
                        break;
                    }
                    case 3: {
                        RetakePhotoDropTargetFragment.this.retakePhoto((DragLocalState)event.getLocalState(), event.getX(), event.getY());
                        break;
                    }
                    case 4: {
                        RetakePhotoDropTargetFragment.this.hideDropTarget();
                        RetakePhotoDropTargetFragment.this.animateDragExit();
                        RetakePhotoDropTargetFragment.this.dropTarget.setBackgroundColor(RetakePhotoDropTargetFragment.this.defaultColor);
                    }
                }
                return true;
            }
        }
        this.dropTarget.setOnDragListener((View.OnDragListener)new DragListener());
    }

    private void retakePhoto(DragLocalState localState, float x, float y) {
        this.eventManager.fire((Object)new RetakePageEvent(localState.getPagePosition(), x, y));
    }

    private void animateDragEnter() {
        this.getView().animate().scaleX(1.15f).scaleY(1.15f).setDuration(200L).translationY((float)this.dropTarget.getHeight() / 2.0f * 0.14999998f).start();
    }

    private void animateBackgroundDragEnter() {
        ValueAnimator colorAnimator = ValueAnimator.ofObject((TypeEvaluator)ARGB_EVALUATOR, (Object[])new Object[]{this.defaultColor, this.activeColor});
        colorAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new ColorUpdateListener());
        colorAnimator.start();
    }

    private void animateDragExit() {
        this.getView().animate().scaleX(1.0f).scaleY(1.0f).translationY(0.0f).start();
    }

    private void animateBackgroundDragExit() {
        ValueAnimator colorAnimator = ValueAnimator.ofObject((TypeEvaluator)ARGB_EVALUATOR, (Object[])new Object[]{this.activeColor, this.defaultColor});
        colorAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new ColorUpdateListener());
        colorAnimator.start();
    }

    private void showDropTarget() {
        this.getView().setAlpha(1.0f);
    }

    private void hideDropTarget() {
        this.getView().animate().alpha(0.0f).start();
    }

    private class ColorUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private ColorUpdateListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            RetakePhotoDropTargetFragment.this.dropTarget.setBackgroundColor(((Integer)animation.getAnimatedValue()).intValue());
        }
    }
}

