/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera;

import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.hardware.Camera;
import android.util.Property;
import android.view.View;
import com.commonsware.cwac.camera.CameraView;
import java.util.Collections;
import java.util.List;
import net.doo.snap.lib.detector.CameraDetectorListener;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.sensor.SignificantMoveListener;
import net.doo.snap.lib.snap.AutoSnappingDetectionHelper;
import net.doo.snap.lib.snap.camera.SnapCameraHost;
import net.doo.snap.lib.snap.util.PolygonHelper;
import net.doo.snap.lib.snap.util.Utils;
import net.doo.snap.lib.util.CameraConfiguration;
import net.doo.snap.lib.util.log.DebugLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapCameraView
extends CameraView
implements CameraDetectorListener,
SignificantMoveListener {
    private static final Property<Paint, Integer> PAINT_ALPHA_PROPERTY = Property.of(Paint.class, Integer.TYPE, (String)"alpha");
    private static final int POLYGON_FADE_OUT_DURATION_MS = 250;
    private static final int DELAY_AFTER_MOVE_MS = 2000;
    private List<PointF> polygon;
    private final Paint paint;
    private boolean isAutoSnapEnabled = true;
    private boolean isAutoFocusing = false;
    private ValueAnimator polygonAnimator;
    private ObjectAnimator polygonAlphaAnimator;
    private PolygonEvaluator polygonEvaluator = new PolygonEvaluator();
    private AutoSnappingDetectionHelper detectionHelper;
    private CameraConfiguration cameraConfiguration;
    private boolean cameraAvailable = false;
    private long lastSignificantMove;
    private float[] points;
    private float[] animationPoints;
    private PolygonHelper polygonHelper;
    private boolean drawPolygon = true;
    private byte[] previewBuffer;

    public SnapCameraView(Context context, AutoSnappingDetectionHelper detectionHelper, CameraConfiguration cameraConfiguration) {
        super(context);
        this.detectionHelper = detectionHelper;
        this.cameraConfiguration = cameraConfiguration;
        this.paint = new Paint();
        this.paint.setColor(this.getResources().getColor(2131099660));
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.getResources().getDimension(2131361797));
        this.paint.setAntiAlias(true);
        this.points = new float[16];
        this.animationPoints = new float[this.points.length];
        this.polygonHelper = new PolygonHelper();
        this.polygon = Collections.emptyList();
    }

    public List<PointF> getPolygon() {
        return this.polygon;
    }

    public void setAutoSnapEnabled(boolean enabled) {
        this.isAutoSnapEnabled = enabled;
        if (!this.isAutoSnapEnabled) {
            this.detectionHelper.reset(true);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.drawPolygon && !this.polygon.isEmpty()) {
            canvas.drawLines(this.points, this.paint);
        }
    }

    @Override
    public void onCameraOpen(Camera camera) throws RuntimeException {
        Camera.Parameters parameters;
        super.onCameraOpen(camera);
        if (camera != null && (parameters = camera.getParameters()) != null && !this.cameraConfiguration.isConigured()) {
            this.cameraConfiguration.loadCameraParameters(parameters);
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        View view = this.getChildAt(0);
        if (view != null) {
            this.polygonHelper.setLayout(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
    }

    @Override
    public void autoFocus() {
        this.isAutoFocusing = true;
        try {
            Camera.Parameters params = this.getCameraParameters();
            Utils.enableAutoFocus(params);
            this.setCameraParameters(params);
            super.autoFocus();
        }
        catch (RuntimeException e) {
            DebugLog.logException(e);
        }
    }

    @Override
    public void onAutoFocus(boolean success, Camera camera) {
        if (this.isAutoFocusing) {
            this.isAutoFocusing = false;
            super.onAutoFocus(success, camera);
        }
    }

    @Override
    public void onDetectionOK(List<PointF> polygon) {
        if (!this.polygon.isEmpty()) {
            this.animateToPolygon(polygon);
        } else {
            this.polygonHelper.polygonToPoints(polygon, this.points);
            this.invalidate();
        }
        this.polygon = polygon;
        boolean movedRecently = System.currentTimeMillis() - this.lastSignificantMove <= 2000L;
        SnapCameraHost host = (SnapCameraHost)this.getHost();
        if (!movedRecently && this.isAutoSnapEnabled && host.useContourDetection()) {
            this.detectionHelper.onResult(DetectionResult.OK);
            if (!this.isAutoFocusing) {
                this.autoFocus();
            }
        }
        this.addPreviewCallbackBuffer(this.previewBuffer);
    }

    @Override
    public void onDetectionWithError(DetectionResult result, List<PointF> polygon) {
        if (this.isAutoSnapEnabled) {
            this.detectionHelper.onResult(result);
        }
        this.polygon = polygon;
        this.animateToPolygon(polygon);
        this.addPreviewCallbackBuffer(this.previewBuffer);
    }

    @Override
    public void onDetectionFailed(DetectionResult result) {
        if (this.isAutoSnapEnabled) {
            this.detectionHelper.onResult(result);
        }
        this.animateToPolygon(Collections.<PointF>emptyList());
        this.addPreviewCallbackBuffer(this.previewBuffer);
    }

    private void animateToPolygon(List<PointF> polygon) {
        if (this.polygonAnimator != null) {
            this.polygonAnimator.cancel();
            this.polygonAnimator = null;
        }
        if (this.polygonAlphaAnimator != null) {
            this.polygonAlphaAnimator.cancel();
            this.polygonAlphaAnimator = null;
        }
        if (polygon.isEmpty()) {
            this.animatePolygonFadeOut();
            return;
        }
        this.paint.setAlpha(255);
        this.polygonHelper.polygonToPoints(polygon, this.animationPoints);
        this.polygonAnimator = ValueAnimator.ofObject((TypeEvaluator)this.polygonEvaluator, (Object[])new Object[]{this.points, this.animationPoints});
        this.polygonAnimator.start();
    }

    private void animatePolygonFadeOut() {
        this.polygonAlphaAnimator = ObjectAnimator.ofInt((Object)this.paint, PAINT_ALPHA_PROPERTY, (int[])new int[]{0});
        this.polygonAlphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                SnapCameraView.this.invalidate();
            }
        });
        this.polygonAlphaAnimator.setDuration(250L);
        this.polygonAlphaAnimator.start();
    }

    public void resetNotifications() {
        this.detectionHelper.reset(true);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.polygonHelper.setRotation(this.getDisplayOrientation());
        if (this.drawPolygon && this.previewBuffer != null) {
            this.addPreviewCallbackBuffer(this.previewBuffer);
        }
        this.cameraAvailable = true;
    }

    @Override
    public void onPause() {
        super.onPause();
        this.cameraAvailable = false;
    }

    @Override
    public void startPreview() {
        if (this.cameraAvailable) {
            super.startPreview();
        }
    }

    @Override
    public void stopPreview() {
        if (this.cameraAvailable) {
            super.stopPreview();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.previewBuffer = ((SnapCameraHost)this.getHost()).getNewPreviewBuffer();
        this.addPreviewCallbackBuffer(this.previewBuffer);
    }

    public void setDrawPolygon(boolean drawPolygon) {
        if (drawPolygon && !this.drawPolygon) {
            this.addPreviewCallbackBuffer(this.previewBuffer);
        }
        this.drawPolygon = drawPolygon;
        this.invalidate();
    }

    @Override
    public float getSignificantMoveThreshold() {
        return 0.6f;
    }

    @Override
    public void onSignificantMove() {
        this.lastSignificantMove = System.currentTimeMillis();
    }

    private class PolygonEvaluator
    implements TypeEvaluator {
        private PolygonEvaluator() {
        }

        public Object evaluate(float fraction, Object startObj, Object endObj) {
            this.evaluatePolygon(fraction, (float[])startObj, (float[])endObj);
            return null;
        }

        private void evaluatePolygon(float fraction, float[] start, float[] end) {
            for (int i = 0; i < SnapCameraView.this.points.length; ++i) {
                ((SnapCameraView)SnapCameraView.this).points[i] = start[i] + fraction * (end[i] - start[i]);
            }
            SnapCameraView.this.invalidate();
        }
    }
}

