package net.doo.snap.lib.snap.edit.events;

import net.doo.snap.lib.persistence.Signature;

/**
 * Fired when signatures of the {@link net.doo.snap.lib.persistence.Page} are changed
 */
public class SignatureChangedEvent {

    private final String pageId;
    private final Signature signature;

    public SignatureChangedEvent(String pageId, Signature signature) {
        this.pageId = pageId;
        this.signature = signature;
    }

    /**
     * @return id of the {@link net.doo.snap.lib.persistence.Page}
     */
    public String getPageId() {
        return pageId;
    }

    /**
     * @return new {@link net.doo.snap.lib.persistence.Signature}s of this {@link net.doo.snap.lib.persistence.Page} or
     * {@code null} if {@link net.doo.snap.lib.persistence.Signature} was removed from {@link net.doo.snap.lib.persistence.Page}
     */
    public Signature getSignature() {
        return signature;
    }

}
