package net.doo.snap.lib.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.DragEvent;
import android.widget.FrameLayout;

/**
 * {@link android.widget.FrameLayout} which always notifies its {@link android.view.View.OnDragListener}
 * (even if one of the children consumes event)
 */
public class DragFrameLayout extends FrameLayout {

    private OnDragListener onDragListener;

    public DragFrameLayout(Context context) {
        super(context);
    }

    public DragFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public DragFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void setOnDragListener(OnDragListener listener) {
        this.onDragListener = listener;
    }

    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    @Override
    public boolean dispatchDragEvent(DragEvent event) {
        if (onDragListener != null) {
            onDragListener.onDrag(this, event);
        }

        return super.dispatchDragEvent(event);
    }
}
