package net.doo.snap.lib.util;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;
import android.text.TextUtils;

import com.google.inject.Inject;
import com.google.inject.Singleton;

import net.doo.snap.lib.R;

import java.util.List;

@Singleton
public class CameraConfiguration {
    private List<String> supportedFlashModes;
    private List<String> supportedFocusModes;
    private List<Integer> supportedPreviewFormats;
    private List<Integer> supportedPictureFormats;
    private List<Camera.Size> supportedPreviewSizes;
    private List<Camera.Size> supportedPictureSizes;

    private boolean isConigured = false;

    @Inject
    public CameraConfiguration() {
    }

    public void loadCameraParameters(Camera.Parameters parameters) {
        supportedFlashModes = parameters.getSupportedFlashModes();
        supportedFocusModes = parameters.getSupportedFocusModes();
        supportedPreviewFormats = parameters.getSupportedPreviewFormats();
        supportedPictureFormats = parameters.getSupportedPictureFormats();
        supportedPreviewSizes = parameters.getSupportedPreviewSizes();
        supportedPictureSizes = parameters.getSupportedPictureSizes();
        isConigured = true;
    }

    public List<String> getSupportedFlashModes() {
        return supportedFlashModes;
    }

    public List<String> getSupportedFocusModes() {
        return supportedFocusModes;
    }

    public List<Integer> getSupportedPreviewFormats() {
        return supportedPreviewFormats;
    }

    public List<Integer> getSupportedPictureFormats() {
        return supportedPictureFormats;
    }

    public List<Camera.Size> getSupportedPreviewSizes() {
        return supportedPreviewSizes;
    }

    public List<Camera.Size> getSupportedPictureSizes() {
        return supportedPictureSizes;
    }

    public boolean isConigured() {
        return isConigured;
    }

    public String toString(Context context) {
        String result = context.getString(R.string.device_configuration,
                Build.PRODUCT,
                Build.DEVICE,
                Build.BOARD,
                Build.HARDWARE,
                Build.MANUFACTURER,
                Build.BRAND,
                Build.MODEL,
                Build.HARDWARE,
                Build.SERIAL,
                Build.FINGERPRINT);

        if (isConigured) {
            result += context.getString(R.string.camera_configuration,
                    getSupportedFlashModes() == null ? "" : TextUtils.join(", ", getSupportedFlashModes()),
                    getSupportedFocusModes() == null ? "" : TextUtils.join(", ", getSupportedFocusModes()),
                    getSupportedPreviewFormats() == null ? "" : TextUtils.join(", ", getSupportedPreviewFormats()),
                    getSupportedPictureFormats() == null ? "" : TextUtils.join(", ", getSupportedPictureFormats()),
                    getSupportedPreviewSizes() == null ? "" : joinSizes(", ", getSupportedPreviewSizes()),
                    getSupportedPictureSizes() == null ? "" : joinSizes(", ", getSupportedPictureSizes())
            );
        }

        return result;
    }

    private String joinSizes(String separator, List<Camera.Size> sizes) {
        String result = "";
        for(Camera.Size size : sizes) {
            if (!result.isEmpty()) {
                result += separator;
            }

            result += size.width + "x" + size.height;
        }

        return result;
    }
}
