/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera;

import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.PointF;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.RelativeLayout;
import com.commonsware.cwac.camera.CameraFragment;
import com.commonsware.cwac.camera.DeviceProfile;
import com.google.inject.Inject;
import java.util.List;
import net.doo.snap.lib.analytics.EasyTrackerWrapper;
import net.doo.snap.lib.detector.CameraDetectorListener;
import net.doo.snap.lib.sensor.SensorHelper;
import net.doo.snap.lib.snap.AutoSnappingDetectionHelper;
import net.doo.snap.lib.snap.camera.CameraPreviewConfiguration;
import net.doo.snap.lib.snap.camera.SnapCameraHost;
import net.doo.snap.lib.snap.camera.SnapCameraView;
import net.doo.snap.lib.snap.event.PictureProcessingStatusChangedEvent;
import net.doo.snap.lib.snap.event.PictureTakenEvent;
import net.doo.snap.lib.snap.util.OrientationHandler;
import net.doo.snap.lib.snap.util.ScreenRotationChangedEvent;
import net.doo.snap.lib.snap.util.Utils;
import net.doo.snap.lib.ui.BarcodeActivity;
import net.doo.snap.lib.ui.Nexus4RebootFragment;
import net.doo.snap.lib.ui.util.ViewUtils;
import net.doo.snap.lib.util.CameraConfiguration;
import net.doo.snap.lib.util.State;
import net.doo.snap.lib.util.StateHolder;
import org.apache.commons.lang.BooleanUtils;
import roboguice.RoboGuice;
import roboguice.event.EventManager;
import roboguice.event.Observes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CameraPreviewFragment
extends CameraFragment {
    private static final int CONTOUR_DETECTION_DELAY_MS = 2000;
    private static final int FLASH_KEEP_DELAY_MS = 10000;
    private static final int MANUAL_SNAPPING_DELAY_MS = 12000;
    private static final int PLACEHOLDER_FADE_OUT_DURATION_MILLIS = 700;
    private static final float TAKE_PICTURE_PRESSED_SCALE = 0.8f;
    private static final float TAKE_PICTURE_OVERSHOOT_TENSION = 8.0f;
    private static final String IS_IN_PREVIEW = "IS_IN_PREVIEW";
    private static final String IS_ACTIVE = "IS_ACTIVE";
    public static final String CAMERA_STARTED = "CAMERA_STARTED";
    private static final int BARCODE_ACTIVITY_REQUEST_CODE = 1;
    @Inject
    private SnapCameraHost snapCameraHost;
    @Inject
    private EventManager eventManager;
    @Inject
    private CameraPreviewConfiguration cameraPreviewConfiguration;
    @Inject
    private OrientationHandler orientationHandler;
    @Inject
    private SharedPreferences preferences;
    @Inject
    private SensorHelper sensorHelper;
    @Inject
    private CameraConfiguration cameraConfiguration;
    private final Handler handler = new Handler();
    private final Runnable switchOffFlashRunnable = new Runnable(){

        public void run() {
            CameraPreviewFragment.this.flashToggle.setChecked(false);
        }
    };
    private final Runnable switchToManualModeRunnable = new Runnable(){

        public void run() {
            if (CameraPreviewFragment.this.isAutosnapEnabled()) {
                CameraPreviewFragment.this.autoToggle.setChecked(false);
            }
        }
    };
    private boolean cameraCanAnimate;
    private boolean isRefocusing = false;
    private final State READY = new State(){

        public void onEnter() {
            if (!CameraPreviewFragment.this.cameraCanAnimate) {
                CameraPreviewFragment.this.cameraPlaceholder.animate().alpha(0.0f).setDuration(700L).start();
                CameraPreviewFragment.this.cameraPreview.setVisibility(0);
            }
            CameraPreviewFragment.this.takePicture.animate().alpha(1.0f).start();
            CameraPreviewFragment.this.flashToggle.animate().alpha(1.0f).start();
            CameraPreviewFragment.this.autoToggle.animate().alpha(1.0f).start();
            CameraPreviewFragment.this.takePicture.setEnabled(true);
            CameraPreviewFragment.this.flashToggle.setEnabled(true);
            CameraPreviewFragment.this.autoToggle.setEnabled(true);
            CameraPreviewFragment.this.cameraPreview.setPreviewCallback(CameraPreviewFragment.this.snapCameraHost);
            new Handler().postDelayed(new Runnable(){

                public void run() {
                    if (CameraPreviewFragment.this.isAdded() && CameraPreviewFragment.this.cameraStateHolder.getCurrentState() == CameraPreviewFragment.this.READY) {
                        CameraPreviewFragment.this.snapCameraHost.setUseContourDetection(true);
                        CameraPreviewFragment.this.cameraPreview.setDrawPolygon(true);
                    }
                }
            }, 2000L);
            CameraPreviewFragment.this.orientationHandler.enable();
            if (CameraPreviewFragment.this.isAutosnapEnabled()) {
                CameraPreviewFragment.this.handler.postDelayed(CameraPreviewFragment.this.switchToManualModeRunnable, 12000L);
            }
            Camera.Parameters params = CameraPreviewFragment.this.cameraPreview.getCameraParameters();
            Utils.enableContinuousFocus(params);
            CameraPreviewFragment.this.cameraPreview.setCameraParameters(params);
            CameraPreviewFragment.this.cameraPreview.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getAction() == 0) {
                        CameraPreviewFragment.this.isRefocusing = true;
                        CameraPreviewFragment.this.autoFocus();
                    }
                    return false;
                }
            });
            CameraPreviewFragment.this.sensorHelper.registerSignificantMoveListener(CameraPreviewFragment.this.cameraPreview);
        }

        public void onLeave() {
            CameraPreviewFragment.this.cameraPlaceholder.animate().cancel();
            CameraPreviewFragment.this.takePicture.animate().cancel();
            CameraPreviewFragment.this.flashToggle.animate().cancel();
            CameraPreviewFragment.this.autoToggle.animate().cancel();
            CameraPreviewFragment.this.orientationHandler.disable();
            CameraPreviewFragment.this.handler.removeCallbacks(CameraPreviewFragment.this.switchToManualModeRunnable);
            CameraPreviewFragment.this.cameraPreview.setOnTouchListener(null);
            CameraPreviewFragment.this.sensorHelper.unregisterSignificantMoveListener(CameraPreviewFragment.this.cameraPreview);
        }
    };
    private final State PREVIEW;
    private State startState = this.PREVIEW = new State(){

        public void onEnter() {
            if (!CameraPreviewFragment.this.cameraCanAnimate) {
                CameraPreviewFragment.this.cameraPlaceholder.setAlpha(1.0f);
                CameraPreviewFragment.this.cameraPreview.setVisibility(8);
            }
            CameraPreviewFragment.this.takePicture.setEnabled(false);
            CameraPreviewFragment.this.flashToggle.setEnabled(false);
            CameraPreviewFragment.this.autoToggle.setEnabled(false);
            CameraPreviewFragment.this.takePicture.animate().alpha(0.0f).scaleX(1.0f).scaleY(1.0f).start();
            CameraPreviewFragment.this.flashToggle.animate().alpha(0.0f).start();
            CameraPreviewFragment.this.autoToggle.animate().alpha(0.0f).start();
            CameraPreviewFragment.this.snapCameraHost.setUseContourDetection(false);
            CameraPreviewFragment.this.cameraPreview.setDrawPolygon(false);
            CameraPreviewFragment.this.cameraPreview.setPreviewCallback(null);
            CameraPreviewFragment.this.cameraPreview.resetNotifications();
            CameraPreviewFragment.this.handler.postDelayed(CameraPreviewFragment.this.switchOffFlashRunnable, 10000L);
        }

        public void onLeave() {
            CameraPreviewFragment.this.takePicture.animate().cancel();
            CameraPreviewFragment.this.flashToggle.animate().cancel();
            CameraPreviewFragment.this.autoToggle.animate().cancel();
            CameraPreviewFragment.this.handler.removeCallbacks(CameraPreviewFragment.this.switchOffFlashRunnable);
        }
    };
    private SnapCameraView cameraPreview;
    private View cameraPlaceholder;
    private CheckBox flashToggle;
    private CheckBox autoToggle;
    private View takePicture;
    private View progressView;
    private boolean active = false;
    private StateHolder cameraStateHolder = new StateHolder();
    private float openedProgress;

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1) {
            this.snapCameraHost.resetBarcodeDetectionTimer();
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.cameraCanAnimate = DeviceProfile.getInstance((Context)activity).useTextureView();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        RoboGuice.getInjector((Context)this.getActivity()).injectMembersWithoutViews((Object)this);
        this.snapCameraHost.setCameraPreviewFragment(this);
        this.setHost(this.snapCameraHost);
    }

    public List<PointF> getPolygon() {
        if (this.cameraPreview != null) {
            return this.cameraPreview.getPolygon();
        }
        return null;
    }

    public int getRotation() {
        int rotation = this.cameraPreview != null ? this.cameraPreview.getDisplayOrientation() : this.getActivity().getWindow().getWindowManager().getDefaultDisplay().getRotation();
        return rotation;
    }

    private void setFlashEnabled(boolean enabled) {
        this.cameraPreviewConfiguration.setFlashEnabled(enabled);
        Camera.Parameters parameters = this.cameraPreview.getCameraParameters();
        if (Utils.isFlashSupported(parameters)) {
            parameters.setFlashMode(enabled ? "torch" : "off");
            this.cameraPreview.setCameraParameters(parameters);
        }
    }

    private void setAutoSnapEnabled(boolean enabled) {
        this.cameraPreviewConfiguration.setAutoSnapEnabled(enabled);
        this.cameraPreview.setAutoSnapEnabled(enabled);
        this.takePicture.setVisibility(enabled ? 8 : 0);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, final Bundle savedInstanceState) {
        RelativeLayout view = (RelativeLayout)inflater.inflate(2130903048, null);
        AutoSnappingDetectionHelper helper = new AutoSnappingDetectionHelper((Context)this.getActivity(), (View)view);
        this.cameraPreview = new SnapCameraView((Context)this.getActivity(), helper, this.cameraConfiguration);
        this.cameraPreview.setHost(this.getHost());
        this.setCameraView(this.cameraPreview);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        view.addView((View)this.cameraPreview, 0, (ViewGroup.LayoutParams)params);
        this.takePicture = view.findViewById(2131165215);
        this.takePicture.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CameraPreviewFragment.this.autoFocus();
            }
        });
        this.takePicture.setOnTouchListener(new View.OnTouchListener(){
            private final Interpolator downInterpolator = new DecelerateInterpolator();
            private final Interpolator upInterpolator = new OvershootInterpolator(8.0f);

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        CameraPreviewFragment.this.takePicture.animate().scaleX(0.8f).scaleY(0.8f).setInterpolator((TimeInterpolator)this.downInterpolator).start();
                        break;
                    }
                    case 1: 
                    case 3: {
                        CameraPreviewFragment.this.takePicture.animate().scaleX(1.0f).scaleY(1.0f).setInterpolator((TimeInterpolator)this.upInterpolator).start();
                    }
                }
                return false;
            }
        });
        this.flashToggle = (CheckBox)view.findViewById(2131165217);
        this.flashToggle.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean checked) {
                CameraPreviewFragment.this.setFlashEnabled(checked);
            }
        });
        this.autoToggle = (CheckBox)view.findViewById(2131165216);
        this.autoToggle.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean checked) {
                CameraPreviewFragment.this.setAutoSnapEnabled(checked);
                EasyTrackerWrapper.sendEvent("ui", "button_press", "auto_snap_toggle", Long.valueOf(BooleanUtils.toInteger((boolean)checked)));
            }
        });
        this.progressView = view.findViewById(2131165218);
        this.cameraPlaceholder = view.findViewById(2131165213);
        if (!this.cameraCanAnimate) {
            this.cameraPlaceholder.setVisibility(0);
        }
        ViewUtils.postOnPreDraw((View)this.cameraPreview, new Runnable(){

            public void run() {
                CameraPreviewFragment.this.restoreState(savedInstanceState);
            }
        });
        return view;
    }

    private void restoreState(Bundle state) {
        if (state == null) {
            this.cameraStateHolder.updateState(this.startState);
            return;
        }
        this.active = state.getBoolean(IS_ACTIVE, false);
        if (state.getBoolean(IS_IN_PREVIEW)) {
            this.cameraStateHolder.updateState(this.PREVIEW);
        } else {
            this.cameraStateHolder.updateState(this.READY);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(IS_IN_PREVIEW, this.cameraStateHolder.getCurrentState() == this.PREVIEW);
        outState.putBoolean(IS_ACTIVE, this.active);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.preferences.getBoolean(CAMERA_STARTED, false)) {
            Nexus4RebootFragment.newInstance().showIfNexus4(this.getFragmentManager());
        }
        this.preferences.edit().putBoolean(CAMERA_STARTED, true).commit();
        this.flashToggle.setChecked(this.cameraPreviewConfiguration.isFlashEnabled());
        this.autoToggle.setChecked(this.cameraPreviewConfiguration.isAutoSnapEnabled());
        if (this.cameraStateHolder.getCurrentState() == this.READY) {
            this.orientationHandler.enable();
        }
        this.setupExceptionHandler();
    }

    private void setupExceptionHandler() {
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread thread, Throwable ex) {
                Thread.UncaughtExceptionHandler defaultHandler;
                if (CameraPreviewFragment.this.cameraPreview != null) {
                    CameraPreviewFragment.this.cameraPreview.onPause();
                }
                if ((defaultHandler = Thread.getDefaultUncaughtExceptionHandler()) != null) {
                    defaultHandler.uncaughtException(thread, ex);
                }
            }
        });
    }

    @Override
    public void onPause() {
        super.onPause();
        this.orientationHandler.disable();
        this.preferences.edit().putBoolean(CAMERA_STARTED, false).commit();
        this.resetExceptionHandler();
    }

    private void resetExceptionHandler() {
        Thread.currentThread().setUncaughtExceptionHandler(Thread.getDefaultUncaughtExceptionHandler());
    }

    public void onDestroyView() {
        this.cameraStateHolder.updateState(State.DEFAULT);
        super.onDestroyView();
    }

    public void setPreviewMode(boolean previewMode) {
        this.active = !previewMode;
        this.startState = previewMode ? this.PREVIEW : this.READY;
        this.cameraStateHolder.updateState(this.startState);
    }

    public boolean isReady() {
        return this.cameraStateHolder.getCurrentState() == this.READY;
    }

    public void setOpenProgress(float progress) {
        this.openedProgress = progress;
        if (!this.active || this.getView() == null) {
            return;
        }
        this.cameraStateHolder.updateState(progress == 1.0f ? this.READY : this.PREVIEW);
    }

    public void setFlashButtonVisible(boolean supported) {
        this.flashToggle.setVisibility(supported ? 0 : 8);
    }

    public boolean isFlashEnabled() {
        return this.flashToggle.isChecked();
    }

    public CameraDetectorListener getDetectorListener() {
        return this.cameraPreview;
    }

    public void onPictureTaken(byte[] image, int imageOrientation) {
        this.eventManager.fire((Object)new PictureTakenEvent(image, imageOrientation));
    }

    public void onStartPictureProcessing() {
        this.eventManager.fire((Object)new PictureProcessingStatusChangedEvent(true));
        this.handler.post(new Runnable(){

            public void run() {
                if (!CameraPreviewFragment.this.isAdded()) {
                    return;
                }
                CameraPreviewFragment.this.progressView.setVisibility(0);
                CameraPreviewFragment.this.cameraStateHolder.updateState(CameraPreviewFragment.this.PREVIEW);
                CameraPreviewFragment.this.cameraPreview.setDrawPolygon(true);
            }
        });
    }

    public void onFinishPictureProcessing() {
        this.eventManager.fire((Object)new PictureProcessingStatusChangedEvent(false));
        this.handler.post(new Runnable(){

            public void run() {
                if (!CameraPreviewFragment.this.isAdded()) {
                    return;
                }
                CameraPreviewFragment.this.progressView.setVisibility(8);
            }
        });
    }

    public void startCameraPreview() {
        this.cameraPreview.startPreview();
    }

    public void setCameraActive(boolean active) {
        if (!this.isAdded()) {
            return;
        }
        this.active = active;
        if (this.active) {
            this.setOpenProgress(this.openedProgress);
        } else {
            this.cameraStateHolder.updateState(this.PREVIEW);
        }
    }

    public void onScreenRotationChanged(@Observes ScreenRotationChangedEvent event) {
        if (!this.isAdded()) {
            return;
        }
        int rotation = -event.getRotation();
        this.flashToggle.animate().rotation((float)rotation).start();
        this.autoToggle.animate().rotation((float)rotation).start();
    }

    public boolean isAutosnapEnabled() {
        return this.autoToggle.isChecked();
    }

    public boolean isRefocusing() {
        return this.isRefocusing;
    }

    public void finishRefocusing() {
        this.isRefocusing = false;
    }

    public void onBarcodeDetected() {
        this.startActivityForResult(new Intent((Context)this.getActivity(), BarcodeActivity.class), 1);
    }
}

