/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.text.TextUtils;
import com.google.zxing.client.result.CalendarParsedResult;
import com.google.zxing.client.result.ParsedResult;
import java.text.DateFormat;
import java.util.Date;
import net.doo.snap.lib.snap.camera.barcode.result.ResultHandler;
import net.doo.snap.lib.util.log.DebugLog;
import org.apache.commons.lang.time.DateUtils;

public final class CalendarResultHandler
extends ResultHandler {
    private static final int[] buttons = new int[]{2131230789};
    private static final int ADD_TO_CALENDAR = 0;
    private static final String INTENT_TYPE = "vnd.android.cursor.item/event";
    private static final String INTENT_BEGIN_TIME = "beginTime";
    private static final String INTENT_ALL_DAY = "allDay";
    private static final String INTENT_END_TIME = "endTime";
    private static final String INTENT_TITLE = "title";
    private static final String INTENT_EVENT_LOCATION = "eventLocation";
    private static final String INTENT_DESCRIPTION = "description";
    private static final DateFormat dateTimeInstance = DateFormat.getDateTimeInstance(2, 2);
    private static final DateFormat dateInstance = DateFormat.getDateInstance(2);

    public CalendarResultHandler(Activity activity, CalendarParsedResult result) {
        super(activity, (ParsedResult)result);
    }

    public CalendarParsedResult getResult() {
        return (CalendarParsedResult)super.getResult();
    }

    public int getButtonCount() {
        return buttons.length;
    }

    public int getButtonText(int index) {
        return buttons[index];
    }

    public void handleButtonPress(int index) {
        if (index == 0) {
            CalendarParsedResult calendarResult = this.getResult();
            String description = calendarResult.getDescription();
            String organizer = calendarResult.getOrganizer();
            if (organizer != null) {
                description = description == null ? organizer : description + '\n' + organizer;
            }
            this.addCalendarEvent(calendarResult.getSummary(), calendarResult.getStart(), calendarResult.isStartAllDay(), calendarResult.getEnd(), calendarResult.getLocation(), description, calendarResult.getAttendees());
        }
    }

    private void addCalendarEvent(String summary, Date start, boolean allDay, Date end, String location, String description, String[] attendees) {
        Intent intent = new Intent("android.intent.action.INSERT");
        intent.setType(INTENT_TYPE);
        long startMilliseconds = start.getTime();
        intent.putExtra(INTENT_BEGIN_TIME, startMilliseconds);
        if (allDay) {
            intent.putExtra(INTENT_ALL_DAY, true);
        }
        long endMilliseconds = end == null ? (allDay ? DateUtils.addDays((Date)DateUtils.ceiling((Date)start, (int)5), (int)1).getTime() - 1L : startMilliseconds) : end.getTime();
        intent.putExtra(INTENT_END_TIME, endMilliseconds);
        intent.putExtra(INTENT_TITLE, summary);
        intent.putExtra(INTENT_EVENT_LOCATION, location);
        intent.putExtra(INTENT_DESCRIPTION, description);
        if (attendees != null) {
            intent.putExtra("android.intent.extra.EMAIL", attendees);
        }
        try {
            this.rawLaunchIntent(intent);
        }
        catch (ActivityNotFoundException anfe) {
            DebugLog.w("No calendar app available that responds to android.intent.action.INSERT");
            intent.setAction("android.intent.action.EDIT");
            this.launchIntent(intent);
        }
    }

    public CharSequence getDisplayContents() {
        return null;
    }

    private static String format(boolean allDay, Date date) {
        if (date == null) {
            return null;
        }
        DateFormat format = allDay ? dateInstance : dateTimeInstance;
        return format.format(date);
    }

    public String getDisplayTitle() {
        return this.getResult().getSummary();
    }

    public String getDisplaySubtitle() {
        CalendarParsedResult calendarResult = this.getResult();
        StringBuilder builder = new StringBuilder(100);
        Date start = calendarResult.getStart();
        ParsedResult.maybeAppend((String)CalendarResultHandler.format(calendarResult.isStartAllDay(), start), (StringBuilder)builder);
        Date end = calendarResult.getEnd();
        if (end != null) {
            if (calendarResult.isEndAllDay() && DateUtils.isSameDay((Date)start, (Date)DateUtils.addMilliseconds((Date)end, (int)-1))) {
                return builder.toString();
            }
            builder.append(" - ");
            ParsedResult.maybeAppend((String)CalendarResultHandler.format(calendarResult.isEndAllDay(), end), (StringBuilder)builder);
        }
        return builder.toString();
    }

    public String getDisplayText() {
        CalendarParsedResult calendarResult = this.getResult();
        StringBuilder builder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)calendarResult.getLocation())) {
            builder.append(calendarResult.getLocation());
        }
        if (!TextUtils.isEmpty((CharSequence)calendarResult.getDescription())) {
            builder.append("\n").append(calendarResult.getDescription());
        }
        return builder.toString();
    }

    public int getDisplayIconRes() {
        return 2130837574;
    }
}

