/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import net.doo.snap.lib.persistence.Signature;
import net.doo.snap.lib.ui.util.TransformableDrawable;
import net.doo.snap.lib.util.bitmap.BitmapUtils;

public class SignedDrawable
extends TransformableDrawable {
    private final Signature signature;
    private final Bitmap signatureBitmap;
    private final float additionalScaleFactor;
    private final Paint paint = new Paint(2);
    private Matrix matrix = new Matrix();
    private RectF rectF = new RectF();

    public SignedDrawable(Drawable wrappedDrawable, float additionalScaleFactor, Signature signature, Bitmap signatureBitmap) throws NullPointerException {
        super(wrappedDrawable);
        this.signature = signature;
        this.additionalScaleFactor = additionalScaleFactor;
        this.signatureBitmap = signatureBitmap;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.drawSignature(canvas);
    }

    public void drawSignature(Canvas canvas) {
        if (this.signature == null || !BitmapUtils.isBitmapValid(this.signatureBitmap)) {
            return;
        }
        int width = this.getIntrinsicWidth();
        int height = this.getIntrinsicHeight();
        this.rectF.set(0.0f, 0.0f, (float)width, (float)height);
        float centerX = this.getBounds().centerX();
        float centerY = this.getBounds().centerY();
        this.matrix.reset();
        this.matrix.setRotate(this.getRotation(), centerX, centerY);
        this.matrix.preScale(this.getScale(), this.getScale(), centerX, centerY);
        this.matrix.mapRect(this.rectF);
        canvas.save();
        canvas.drawBitmap(this.signatureBitmap, 0.0f, 0.0f, this.paint);
        canvas.restore();
    }
}

