package net.doo.snap.lib.billing;

import android.content.Context;
import android.content.Intent;

/**
 * Manages user's purchases and access to in-app billing service
 */
public class BillingManager {

    /**
     * Opens connection to billing service and asynchronously updates the status of user's purchases.
     * When you're done with {@link net.doo.snap.lib.billing.BillingManager}, call {@link #dispose()}
     */
    public void initialize(Context context) {
    }

    /**
     * Checks locally if item is available for user. Can be used from main thread.
     *
     * @param itemId id of SKU being checked
     * @return {@code true} if item is available. {@code false} otherwise.
     */
    public boolean isItemAvailable(String itemId) {
        return false;
    }

    /**
     * Updates local state of purchased items. This is a blocking request, do not use it in main thread.
     */
    public void refreshItems() {
    }

    /**
     * Starts Google Play billing workflow for provided SKU id.
     *
     * @param itemId SKU id
     */
    public void startBillingWorkflowForItem(String itemId) {
    }

    /**
     * Handles result posted to {@link android.app.Activity#onActivityResult(int, int, android.content.Intent)}.
     * Either consumes result by returning {@code true}, or ignores it by returning {@code false}.
     *
     * @return {@code true} if result was processed by {@link net.doo.snap.lib.billing.BillingManager}.
     * {@code false} if result was ignored by {@link net.doo.snap.lib.billing.BillingManager}
     */
    public boolean handleResult(int requestCode, int resultCode, Intent data) {
        return false;
    }

    /**
     * Releases connections and resources held by {@link net.doo.snap.lib.billing.BillingManager}
     */
    public void dispose() {
    }

}
