package net.doo.snap.lib.analytics;

import android.app.Activity;

import com.adjust.sdk.Adjust;
import com.google.analytics.tracking.android.EasyTracker;

import net.doo.snap.lib.BuildConfig;

import java.util.HashMap;
import java.util.Map;

/**
 * Wraps {@link com.google.analytics.tracking.android.EasyTracker} to not produce analytic reports while
 * in debug mode
 */
public class EasyTrackerWrapper {

    /**
     * @see com.google.analytics.tracking.android.Tracker#sendEvent(String, String, String, Long)
     */
    public static void sendEvent(String category, String action, String label, Long value) {
        if (BuildConfig.DEBUG) return;
        EasyTracker.getTracker().sendEvent(category, action, label, value);

        Map<String, String> parameters = new HashMap<String, String>();
        parameters.put("category", category);
        parameters.put("action", action);
        parameters.put("label", label);
        parameters.put("value", String.valueOf(value));
        Adjust.trackEvent(AnalyticsConst.ADJUST_ANDROID_EVENT_TOKEN, parameters);
    }

    /**
     * @see com.google.analytics.tracking.android.EasyTracker#activityStart(android.app.Activity)
     */
    public static void activityStart(Activity activity) {
        if (BuildConfig.DEBUG) return;
        EasyTracker.getInstance().activityStart(activity);
    }

    /**
     * @see com.google.analytics.tracking.android.EasyTracker#activityStop(android.app.Activity)
     */
    public static void activityStop(Activity activity) {
        if (BuildConfig.DEBUG) return;
        EasyTracker.getInstance().activityStop(activity);
    }

    /**
     * @see com.adjust.sdk.Adjust#onResume(android.app.Activity)
     */
    public static void activityResume(Activity activity) {
        if (BuildConfig.DEBUG) return;
        Adjust.onResume(activity);
    }

    /**
     * @see com.adjust.sdk.Adjust#onPause()
     */
    public static void activityPause(Activity activity) {
        if (BuildConfig.DEBUG) return;
        Adjust.onPause();
    }

}
