package net.doo.snap.lib.billing;

/**
 * Represents a functionality of the app managed by {@link net.doo.snap.lib.billing.BillingManager}.
 * Therefore, execution of {@link net.doo.snap.lib.billing.Feature} is either allowed or prohibited,
 * depending on the state of {@link net.doo.snap.lib.billing.BillingManager}.
 */
public abstract class Feature {

    private final String id;

    public Feature(String id) {
        this.id = id;
    }

    /**
     * @return id of app's feature which corresponds to SKU id in billing service
     */
    public String getId() {
        return id;
    }

    /**
     * Performs an execution of feature if {@link net.doo.snap.lib.billing.BillingManager} grants permission
     * for that.
     *
     * @return {@code true} if execution completed successfully.
     * {@code false} if {@link net.doo.snap.lib.billing.BillingManager} prohibits
     * execution of {@link net.doo.snap.lib.billing.Feature}.
     */
    public boolean execute(BillingManager billingManager) {
        if (billingManager.isItemAvailable(id)) {
            run();
            return true;
        }
        return false;
    }

    /**
     * Implementation of feature itself.
     */
    protected abstract void run();

}
