/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.CameraView;
import com.commonsware.cwac.camera.PictureTransaction;
import com.commonsware.cwac.camera.SimpleCameraHost;
import com.commonsware.cwac.camera.ZoomTransaction;
import java.io.IOException;

@TargetApi(value=11)
public class CameraFragment
extends Fragment {
    private CameraView cameraView = null;
    private CameraHost host = null;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.cameraView = new CameraView((Context)this.getActivity());
        this.cameraView.setHost(this.getHost());
        return this.cameraView;
    }

    public void onResume() {
        super.onResume();
        this.cameraView.onResume();
    }

    public void onPause() {
        if (this.isRecording()) {
            try {
                this.stopRecording();
            }
            catch (IOException e) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Exception stopping recording in onPause()", (Throwable)e);
            }
        }
        this.cameraView.onPause();
        super.onPause();
    }

    protected void setCameraView(CameraView cameraView) {
        this.cameraView = cameraView;
    }

    public CameraHost getHost() {
        if (this.host == null) {
            this.host = new SimpleCameraHost((Context)this.getActivity());
        }
        return this.host;
    }

    public void setHost(CameraHost host) {
        this.host = host;
    }

    public void takePicture() {
        this.takePicture(false, true);
    }

    public void takePicture(boolean needBitmap, boolean needByteArray) {
        this.cameraView.takePicture(needBitmap, needByteArray);
    }

    public void takePicture(PictureTransaction xact) {
        this.cameraView.takePicture(xact);
    }

    public boolean isRecording() {
        return this.cameraView == null ? false : this.cameraView.isRecording();
    }

    public void record() throws Exception {
        this.cameraView.record();
    }

    public void stopRecording() throws IOException {
        this.cameraView.stopRecording();
    }

    public int getDisplayOrientation() {
        return this.cameraView.getDisplayOrientation();
    }

    public void lockToLandscape(boolean enable) {
        this.cameraView.lockToLandscape(enable);
    }

    public void autoFocus() {
        this.cameraView.autoFocus();
    }

    public void cancelAutoFocus() {
        this.cameraView.cancelAutoFocus();
    }

    public boolean isAutoFocusAvailable() {
        return this.cameraView.isAutoFocusAvailable();
    }

    public void restartPreview() {
        this.cameraView.restartPreview();
    }

    public String getFlashMode() {
        return this.cameraView.getFlashMode();
    }

    public ZoomTransaction zoomTo(int level) {
        return this.cameraView.zoomTo(level);
    }

    public void startFaceDetection() {
        this.cameraView.startFaceDetection();
    }

    public void stopFaceDetection() {
        this.cameraView.stopFaceDetection();
    }

    public boolean doesZoomReallyWork() {
        return this.cameraView.doesZoomReallyWork();
    }

    public void setFlashMode(String mode) {
        this.cameraView.setFlashMode(mode);
    }
}

