/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.persistence;

import android.content.Context;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import net.doo.snap.lib.persistence.Signature;
import net.doo.snap.lib.util.FileUtils;

public class SignatureStoreStrategy {
    private static final String LAST_DRAWN_SIGNATURE = "lastDrawnSignature";
    private static final String SIGNATURES_FOLDER = "signatures";
    @Inject
    private Context context;

    @Inject
    public SignatureStoreStrategy(Context context) {
        this.context = context;
    }

    public File getSignatureFile(Signature signature) throws IOException {
        return this.getSignatureFile(signature.getId());
    }

    public File getSignatureFile(String id2) throws IOException {
        File dir = FileUtils.getExternalFilesDirOrShowError(this.context, SIGNATURES_FOLDER);
        return org.apache.commons.io.FileUtils.getFile((File)dir, (String[])new String[]{id2});
    }

    public File getLastDrawnSignatureFile() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)FileUtils.getExternalFilesDirOrShowError(this.context, SIGNATURES_FOLDER), (String[])new String[]{LAST_DRAWN_SIGNATURE});
    }

    public void eraseSignature(String signatureId) throws IOException {
        File signatureFile = this.getSignatureFile(signatureId);
        if (signatureFile == null) {
            throw new IOException("Can't get file");
        }
        org.apache.commons.io.FileUtils.forceDelete((File)signatureFile);
    }
}

