/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;
import com.google.zxing.Result;
import com.google.zxing.client.result.AddressBookParsedResult;
import com.google.zxing.client.result.CalendarParsedResult;
import com.google.zxing.client.result.EmailAddressParsedResult;
import com.google.zxing.client.result.GeoParsedResult;
import com.google.zxing.client.result.ISBNParsedResult;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.SMSParsedResult;
import com.google.zxing.client.result.TelParsedResult;
import com.google.zxing.client.result.URIParsedResult;
import com.google.zxing.client.result.WifiParsedResult;
import net.doo.snap.lib.snap.camera.barcode.result.AddressBookResultHandler;
import net.doo.snap.lib.snap.camera.barcode.result.CalendarResultHandler;
import net.doo.snap.lib.snap.camera.barcode.result.EmailAddressResultHandler;
import net.doo.snap.lib.snap.camera.barcode.result.GeoResultHandler;
import net.doo.snap.lib.snap.camera.barcode.result.ISBNResultHandler;
import net.doo.snap.lib.snap.camera.barcode.result.ProductResultHandler;
import net.doo.snap.lib.snap.camera.barcode.result.ResultHandler;
import net.doo.snap.lib.snap.camera.barcode.result.SMSResultHandler;
import net.doo.snap.lib.snap.camera.barcode.result.TelResultHandler;
import net.doo.snap.lib.snap.camera.barcode.result.TextResultHandler;
import net.doo.snap.lib.snap.camera.barcode.result.URIResultHandler;
import net.doo.snap.lib.snap.camera.barcode.result.WifiResultHandler;

public final class ResultHandlerFactory {
    private ResultHandlerFactory() {
    }

    public static ResultHandler makeResultHandler(Activity activity, Result rawResult) {
        ParsedResult result = ResultHandlerFactory.parseResult(rawResult);
        switch (result.getType()) {
            case ADDRESSBOOK: {
                return new AddressBookResultHandler(activity, (AddressBookParsedResult)result);
            }
            case EMAIL_ADDRESS: {
                return new EmailAddressResultHandler(activity, (EmailAddressParsedResult)result);
            }
            case PRODUCT: {
                return new ProductResultHandler(activity, result);
            }
            case URI: {
                return new URIResultHandler(activity, (URIParsedResult)result);
            }
            case WIFI: {
                return new WifiResultHandler(activity, (WifiParsedResult)result);
            }
            case GEO: {
                return new GeoResultHandler(activity, (GeoParsedResult)result);
            }
            case TEL: {
                return new TelResultHandler(activity, (TelParsedResult)result);
            }
            case SMS: {
                return new SMSResultHandler(activity, (SMSParsedResult)result);
            }
            case CALENDAR: {
                return new CalendarResultHandler(activity, (CalendarParsedResult)result);
            }
            case ISBN: {
                return new ISBNResultHandler(activity, (ISBNParsedResult)result);
            }
        }
        return new TextResultHandler(activity, result);
    }

    private static ParsedResult parseResult(Result rawResult) {
        return ResultParser.parseResult((Result)rawResult);
    }
}

