/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.hardware.Camera;
import com.commonsware.cwac.camera.CameraHost;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CameraUtils {
    private static final double ASPECT_TOLERANCE = 0.1;

    public static Camera.Size getOptimalPreviewSize(int displayOrientation, int width, int height, Camera.Parameters parameters) {
        double targetRatio = (double)width / (double)height;
        List sizes = parameters.getSupportedPreviewSizes();
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = height;
        if (displayOrientation == 90 || displayOrientation == 270) {
            targetRatio = (double)height / (double)width;
        }
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            if (!(Math.abs(ratio - targetRatio) <= 0.1) || !((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - targetHeight);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : sizes) {
                if (!((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.height - targetHeight);
            }
        }
        return optimalSize;
    }

    public static Camera.Size getBestAspectPreviewSize(int displayOrientation, int width, int height, Camera.Parameters parameters) {
        return CameraUtils.getBestAspectPreviewSize(displayOrientation, width, height, parameters, 0.0);
    }

    public static Camera.Size getBestAspectPreviewSize(int displayOrientation, int width, int height, Camera.Parameters parameters, double closeEnough) {
        double targetRatio = (double)width / (double)height;
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        if (displayOrientation == 90 || displayOrientation == 270) {
            targetRatio = (double)height / (double)width;
        }
        List sizes = parameters.getSupportedPreviewSizes();
        Collections.sort(sizes, Collections.reverseOrder(new SizeComparator()));
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            if (Math.abs(ratio - targetRatio) < minDiff) {
                optimalSize = size;
                minDiff = Math.abs(ratio - targetRatio);
            }
            if (!(minDiff < closeEnough)) continue;
            break;
        }
        return optimalSize;
    }

    public static Camera.Size getLargestPictureSize(CameraHost host, Camera.Parameters parameters) {
        return CameraUtils.getLargestPictureSize(host, parameters, true);
    }

    public static Camera.Size getLargestPictureSize(CameraHost host, Camera.Parameters parameters, boolean enforceProfile) {
        Camera.Size result = null;
        for (Camera.Size size : parameters.getSupportedPictureSizes()) {
            if (enforceProfile && (size.height > host.getDeviceProfile().getMaxPictureHeight() || size.height < host.getDeviceProfile().getMinPictureHeight())) continue;
            if (result == null) {
                result = size;
                continue;
            }
            int newArea = size.width * size.height;
            int resultArea = result.width * result.height;
            if (newArea <= resultArea) continue;
            result = size;
        }
        if (result == null && enforceProfile) {
            result = CameraUtils.getLargestPictureSize(host, parameters, false);
        }
        return result;
    }

    public static Camera.Size getSmallestPictureSize(Camera.Parameters parameters) {
        Camera.Size result = null;
        for (Camera.Size size : parameters.getSupportedPictureSizes()) {
            if (result == null) {
                result = size;
                continue;
            }
            int newArea = size.width * size.height;
            int resultArea = result.width * result.height;
            if (newArea >= resultArea) continue;
            result = size;
        }
        return result;
    }

    public static String findBestFlashModeMatch(Camera.Parameters params, String ... modes) {
        String match = null;
        List flashModes = params.getSupportedFlashModes();
        if (flashModes != null) {
            for (String mode : modes) {
                if (!flashModes.contains(mode)) continue;
                match = mode;
                break;
            }
        }
        return match;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SizeComparator
    implements Comparator<Camera.Size> {
        private SizeComparator() {
        }

        @Override
        public int compare(Camera.Size lhs, Camera.Size rhs) {
            int left = lhs.width * lhs.height;
            int right = rhs.width * rhs.height;
            if (left < right) {
                return -1;
            }
            if (left > right) {
                return 1;
            }
            return 0;
        }
    }
}

