/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.util.billing;

import org.json.JSONException;
import org.json.JSONObject;

public class Purchase {
    private String itemType;
    private String orderId;
    private String packageName;
    private String sku;
    private long purchaseTime;
    private int purchaseState;
    private String developerPayload;
    private String token;
    private String originalJson;
    private String signature;

    public Purchase(String itemType, String jsonPurchaseInfo, String signature) throws JSONException {
        this.itemType = itemType;
        this.originalJson = jsonPurchaseInfo;
        JSONObject jsonObject = new JSONObject(this.originalJson);
        this.orderId = jsonObject.optString("orderId");
        this.packageName = jsonObject.optString("packageName");
        this.sku = jsonObject.optString("productId");
        this.purchaseTime = jsonObject.optLong("purchaseTime");
        this.purchaseState = jsonObject.optInt("purchaseState");
        this.developerPayload = jsonObject.optString("developerPayload");
        this.token = jsonObject.optString("token", jsonObject.optString("purchaseToken"));
        this.signature = signature;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSku() {
        return this.sku;
    }

    public long getPurchaseTime() {
        return this.purchaseTime;
    }

    public int getPurchaseState() {
        return this.purchaseState;
    }

    public String getDeveloperPayload() {
        return this.developerPayload;
    }

    public String getToken() {
        return this.token;
    }

    public String getOriginalJson() {
        return this.originalJson;
    }

    public String getSignature() {
        return this.signature;
    }

    public String toString() {
        return "PurchaseInfo(type:" + this.itemType + "):" + this.originalJson;
    }
}

