/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.util.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.FileObserver;
import android.os.Handler;
import android.support.v4.content.AsyncTaskLoader;
import net.doo.snap.lib.util.bitmap.BitmapLruCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageBitmapLoader
extends AsyncTaskLoader<Bitmap> {
    private static final long INITIAL_RETRY_INTERVAL_MS = 2000L;
    private static final int MAX_RETRY_ATTEMPTS = 8;
    private BitmapLruCache bitmapLruCache;
    protected String imagePath;
    private FileObserver fileObserver;
    private Handler handler = new Handler();
    private Runnable forceLoadRunnable = new Runnable(){

        public void run() {
            if (PageBitmapLoader.this.isStarted()) {
                PageBitmapLoader.this.forceLoad();
            }
        }
    };
    private int retryAttempts = 0;
    private Bitmap bitmap;
    private static final FileObserver NULL_FILE_OBSERVER = new FileObserver(null){

        public void onEvent(int i, String s) {
        }

        protected void finalize() {
        }

        public void startWatching() {
        }

        public void stopWatching() {
        }
    };

    public PageBitmapLoader(Context context, String imagePath, BitmapLruCache bitmapLruCache, Bitmap preservedBitmap) {
        this(context, imagePath, bitmapLruCache, preservedBitmap, true);
    }

    public PageBitmapLoader(Context context, String imagePath, BitmapLruCache bitmapLruCache, Bitmap preservedBitmap, boolean registerObserver) {
        super(context);
        this.imagePath = imagePath;
        this.bitmapLruCache = bitmapLruCache;
        this.bitmap = preservedBitmap;
        this.fileObserver = registerObserver ? new FileObserver(imagePath, 8){

            public void onEvent(int event, String path) {
                PageBitmapLoader.this.handler.post(PageBitmapLoader.this.forceLoadRunnable);
            }
        } : NULL_FILE_OBSERVER;
    }

    public Bitmap loadInBackground() {
        return this.imagePath != null ? BitmapFactory.decodeFile((String)this.imagePath) : null;
    }

    public void deliverResult(Bitmap data) {
        this.handler.removeCallbacks(this.forceLoadRunnable);
        if (this.isReset() || data == null) {
            this.bitmap = null;
            if (!this.isReset() && this.retryAttempts < 8) {
                ++this.retryAttempts;
                this.handler.postDelayed(this.forceLoadRunnable, 2000L * (long)this.retryAttempts);
            }
            return;
        }
        if (this.bitmapLruCache != null && !data.equals(this.bitmap)) {
            this.bitmapLruCache.put(this.imagePath, data);
        }
        this.bitmap = data;
        if (this.isStarted()) {
            this.fileObserver.startWatching();
            super.deliverResult((Object)this.bitmap);
        }
    }

    protected void onStartLoading() {
        boolean dataValid;
        if (this.imagePath == null) {
            this.deliverResult(null);
            return;
        }
        if (this.bitmapLruCache == null) {
            this.forceLoad();
            return;
        }
        this.checkCache();
        boolean bl = dataValid = this.bitmap != null;
        if (dataValid) {
            this.deliverResult(this.bitmap);
        }
        if (this.takeContentChanged() || !dataValid) {
            this.forceLoad();
        }
    }

    protected void onReset() {
        super.onReset();
        this.cancelLoad();
        this.bitmap = null;
        this.retryAttempts = 0;
        this.fileObserver.stopWatching();
    }

    protected void onAbandon() {
        super.onAbandon();
        this.fileObserver.stopWatching();
    }

    private void checkCache() {
        if (this.bitmap == null) {
            this.bitmap = (Bitmap)this.bitmapLruCache.get(this.imagePath);
        }
    }
}

