/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.persistence;

import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Looper;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import net.doo.snap.lib.util.FileUtils;
import net.doo.snap.lib.util.log.DebugLog;

public class PageStoreStrategy {
    private Application context;

    @Inject
    public PageStoreStrategy(Application context) {
        this.context = context;
    }

    public File getPagesDir() throws IOException {
        return FileUtils.getExternalFilesDirOrShowError((Context)this.context, "snapping_pages");
    }

    public File getPageDir(String pageId) throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId});
    }

    public void erasePage(String pageId) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new AsyncTask<String, Void, Void>(){

                protected Void doInBackground(String ... params) {
                    String pageId = params[0];
                    PageStoreStrategy.this.erasePageSync(pageId);
                    return null;
                }
            }.execute((Object[])new String[]{pageId});
        } else {
            this.erasePageSync(pageId);
        }
    }

    private void erasePageSync(String pageId) {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)this.getPageDir(pageId));
        }
        catch (IOException e) {
            DebugLog.logException(e);
        }
    }
}

