/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.edit.drag;

import android.animation.Animator;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Parcelable;
import android.view.DragEvent;
import android.view.View;
import com.google.inject.Inject;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.snap.PreviewFragmentPagerAdapter;
import net.doo.snap.lib.snap.edit.EditLock;
import net.doo.snap.lib.snap.edit.PagesEditor;
import net.doo.snap.lib.snap.edit.drag.DragLocalState;
import net.doo.snap.lib.snap.edit.util.PageEditorHelper;
import net.doo.snap.lib.snap.preview.ImagePreviewFragment;
import net.doo.snap.lib.ui.util.ViewUtils;
import net.doo.snap.lib.ui.widget.ViewPager;

public class PagesRearranger
implements PagesEditor,
View.OnDragListener {
    public static final float DRAG_SHADOW_SCALE = 0.5f;
    public static final float DRAG_SHADOW_ALPHA = 0.5f;
    private static final long DRAG_SHADOW_SCALE_DURATION_MILLIS = 150L;
    private static final long SCROLL_DELAY_MILLIS = 500L;
    private static final int SCROLL_LEFT_MODIFIER = -1;
    private static final int SCROLL_RIGHT_MODIFIER = 1;
    private Resources resources;
    private EditLock editLock;
    private float scrollAreaWidth;
    private ViewPager viewPager;
    private PreviewFragmentPagerAdapter adapter;
    private PageEditorHelper editorHelper;
    private Handler pagesScrollHandler = new Handler();
    private boolean waitingForScroll = false;
    private boolean rearrangementIdle = false;
    private boolean rearrangementEndDelayed = false;
    private boolean dragActive = false;
    private boolean dropped = false;
    private DragInfo dragInfo;

    @Inject
    public PagesRearranger(Resources resources, EditLock editLock) {
        this.resources = resources;
        this.editLock = editLock;
    }

    public void attachViewPager(ViewPager viewPager, PreviewFragmentPagerAdapter adapter) {
        this.initParams();
        this.viewPager = viewPager;
        this.adapter = adapter;
        this.editorHelper = new PageEditorHelper(viewPager, adapter);
        viewPager.setOnDragListener(this);
    }

    private void initParams() {
        this.scrollAreaWidth = this.resources.getDimension(2131361794);
    }

    public void startRearrangement(float startX, float startY, View view, Page draggedPage, int pagePosition, ImagePreviewFragment draggedFragment, Bitmap preservedBitmap) {
        final DragLocalState dragLocalState = new DragLocalState(draggedFragment, preservedBitmap, draggedPage, pagePosition);
        final View viewToAnimate = view;
        viewToAnimate.setOnDragListener(new View.OnDragListener(){

            public boolean onDrag(View v, DragEvent event) {
                if (event.getAction() == 4) {
                    ViewUtils.restoreViewTransformation(viewToAnimate);
                }
                return false;
            }
        });
        this.editLock.lockEdit();
        ViewUtils.saveViewTransformation(viewToAnimate);
        viewToAnimate.animate().scaleX(0.5f).scaleY(0.5f).translationX(startX - (float)viewToAnimate.getWidth() / 2.0f).translationY(startY - (float)viewToAnimate.getHeight() / 2.0f).alpha(0.5f).setDuration(150L).setListener((Animator.AnimatorListener)new ViewUtils.DefaultAnimationListener(){

            public void onAnimationFinished(Animator animation) {
                boolean dragStarted = viewToAnimate.startDrag(null, (View.DragShadowBuilder)new PageShadowBuilder(viewToAnimate), (Object)dragLocalState, 0);
                if (!dragStarted) {
                    PagesRearranger.this.editLock.unlockEdit();
                    ViewUtils.restoreViewTransformation(viewToAnimate);
                } else {
                    viewToAnimate.setAlpha(0.0f);
                }
            }
        }).start();
    }

    public boolean onDrag(View view, DragEvent dragEvent) {
        ImagePreviewFragment currentFragment = this.adapter.getFragment(this.viewPager, this.viewPager.getCurrentItem());
        switch (dragEvent.getAction()) {
            case 1: {
                if (this.adapter.getPagesCount() == 1) {
                    return false;
                }
                this.dragInfo = new DragInfo((DragLocalState)dragEvent.getLocalState());
                this.onRearrangementStarted();
                this.dragActive = true;
                this.dropped = false;
                break;
            }
            case 2: {
                if (currentFragment == null || currentFragment.equals((Object)this.dragInfo.getDragLocalState().getDraggedFragment())) break;
                if (this.handleScroll(dragEvent)) {
                    currentFragment.hideDropTarget();
                    break;
                }
                if (dragEvent.getX() < (float)this.viewPager.getWidth() / 2.0f) {
                    currentFragment.showLeftDropTarget();
                    break;
                }
                currentFragment.showRightDropTarget();
                break;
            }
            case 6: {
                if (currentFragment == null) break;
                currentFragment.hideDropTarget();
                break;
            }
            case 3: {
                this.dragInfo.setDropPosition(dragEvent.getX(), dragEvent.getY());
                if (!this.rearrangementIdle) {
                    this.rearrangementEndDelayed = true;
                    break;
                }
                this.performDropAction();
                break;
            }
            case 4: {
                if (this.dragActive && !this.dropped && !this.rearrangementEndDelayed) {
                    this.cancelRearrangement(dragEvent);
                }
                currentFragment.hideDropTarget();
                this.dragActive = false;
                this.editLock.unlockEdit();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRearrangement(DragEvent dragEvent) {
        try {
            DragLocalState dragLocalState = (DragLocalState)dragEvent.getLocalState();
            this.adapter.addPage(dragLocalState.getPagePosition(), dragLocalState.getPage());
            this.viewPager.setCurrentItem(dragLocalState.getPagePosition());
        }
        finally {
            this.finalizeRearrangement();
        }
    }

    private void performDropAction() {
        ImagePreviewFragment currentFragment = this.adapter.getFragment(this.viewPager, this.viewPager.getCurrentItem());
        this.stopScroll();
        currentFragment.hideDropTarget();
        this.onRearrangementEnded();
    }

    private boolean handleScroll(DragEvent dragEvent) {
        int currentItem = this.viewPager.getCurrentItem();
        float x = dragEvent.getX();
        if (currentItem > 0 && x < this.scrollAreaWidth) {
            if (!this.waitingForScroll) {
                this.pagesScrollHandler.postDelayed((Runnable)new ScrollRunnable(-1), 500L);
            }
            this.waitingForScroll = true;
            return true;
        }
        if (currentItem < this.adapter.getPagesCount() - 1 && x > (float)this.viewPager.getWidth() - this.scrollAreaWidth) {
            if (!this.waitingForScroll) {
                this.pagesScrollHandler.postDelayed((Runnable)new ScrollRunnable(1), 500L);
            }
            this.waitingForScroll = true;
            return true;
        }
        this.stopScroll();
        return false;
    }

    private void stopScroll() {
        this.pagesScrollHandler.removeCallbacksAndMessages(null);
        this.waitingForScroll = false;
    }

    private void onRearrangementStarted() {
        this.rearrangementIdle = false;
        this.editorHelper.deleteCurrentPage(new ViewUtils.DefaultAnimationListener(){

            public void onAnimationFinished(Animator animation) {
                PagesRearranger.this.viewPager.post(new Runnable(){

                    public void run() {
                        PagesRearranger.this.onRearrangementIdle();
                    }
                });
            }
        });
    }

    private void onRearrangementIdle() {
        this.rearrangementIdle = true;
        if (this.rearrangementEndDelayed) {
            this.performDropAction();
            this.rearrangementEndDelayed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRearrangementEnded() {
        try {
            Page page = this.dragInfo.getDragLocalState().getPage();
            page.getParameters().putBoolean("PLAY_DROP_IN_ANIMATION", true);
            page.getParameters().putFloat("DROP_X", this.dragInfo.getDropPositionX());
            page.getParameters().putFloat("DROP_Y", this.dragInfo.getDropPositionY());
            Bitmap preservedBitmap = this.dragInfo.getDragLocalState().getPreservedBitmap();
            if (preservedBitmap != null) {
                page.getParameters().putParcelable("PRESERVED_BITMAP", (Parcelable)preservedBitmap);
            }
            if (this.dragInfo.getDropPositionX() < (float)this.viewPager.getWidth() / 2.0f) {
                this.editorHelper.addPageToTheLeft(page, null);
            } else {
                this.editorHelper.addPageToTheRight(page, null);
            }
            this.dropped = true;
        }
        finally {
            this.finalizeRearrangement();
        }
    }

    private void finalizeRearrangement() {
        this.dragInfo = null;
    }

    public boolean isDragging() {
        return this.dragActive;
    }

    private class PageShadowBuilder
    extends View.DragShadowBuilder {
        public PageShadowBuilder(View view) {
            super(view);
        }

        public void onDrawShadow(Canvas canvas) {
            View view = this.getView();
            if (view == null) {
                super.onDrawShadow(canvas);
                return;
            }
            canvas.save();
            canvas.scale(0.5f, 0.5f, (float)view.getWidth() / 2.0f, (float)view.getHeight() / 2.0f);
            super.onDrawShadow(canvas);
            canvas.restore();
        }
    }

    private class DragInfo {
        private final DragLocalState dragLocalState;
        private float x;
        private float y;

        private DragInfo(DragLocalState dragLocalState) {
            this.dragLocalState = dragLocalState;
        }

        public DragLocalState getDragLocalState() {
            return this.dragLocalState;
        }

        public float getDropPositionX() {
            return this.x;
        }

        public float getDropPositionY() {
            return this.y;
        }

        public void setDropPosition(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }

    private class ScrollRunnable
    implements Runnable {
        private final int pageModifier;

        ScrollRunnable(int pageModifier) {
            this.pageModifier = pageModifier;
        }

        public void run() {
            int newItem = PagesRearranger.this.viewPager.getCurrentItem() + this.pageModifier;
            if (newItem >= 0 && newItem < PagesRearranger.this.adapter.getCount() - 1) {
                PagesRearranger.this.viewPager.setCurrentItem(newItem, true);
                PagesRearranger.this.pagesScrollHandler.postDelayed((Runnable)this, 500L);
            }
        }
    }
}

