package net.doo.snap.lib.detector;

/**
 * Result from {@link ContourDetector#detect(byte[], int, int)}
 *
 * @author René Jeschke (rene_jeschke@yahoo.de)
 */
public enum DetectionResult
{
    /** A good polygon was detected. */
    OK,
    /** A polygon was detected but was too small. */
    OK_BUT_TOO_SMALL,
    /** A polygon was detected but it is distorted too much. */
    OK_BUT_BAD_ANGLES,
    /** A polygon was detected but its aspect ratio is wrong. */
    OK_BUT_BAD_ASPECT_RATIO,

    /** A barcode was detected. */
    OK_BARCODE,

    /** No polygon detected. */
    ERROR_NOTHING_DETECTED,
    /** No polygon detected, image too dark. (Not yet used) */
    ERROR_TOO_DARK,
    /** No polygon detected, image too noisy (background). */
    ERROR_TOO_NOISY
}
