package net.doo.snap.lib.snap.util;

import android.app.Activity;
import android.content.pm.ActivityInfo;

import com.google.inject.Inject;

import net.doo.snap.lib.R;

import roboguice.activity.event.OnCreateEvent;
import roboguice.event.Observes;

/**
 * When injected into {@link android.app.Activity}, locks screen orientation in landscape mode for
 * big devices (presumably tablets) and in portrait mode for the rest.
 */
public class OrientationLocker {

    private Activity activity;

    @Inject
    public OrientationLocker(Activity activity) {
        this.activity = activity;
    }

    @SuppressWarnings("unused")
    public void onCreate(@Observes OnCreateEvent event) {
        setupOrientation();
    }

    private void setupOrientation() {
        activity.setRequestedOrientation(
                activity.getResources().getBoolean(R.bool.orientation_portrait)
                        ? ActivityInfo.SCREEN_ORIENTATION_PORTRAIT
                        : ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE
        );
    }

}
