/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.util.ui;

import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CompositeTouchListener
implements View.OnTouchListener {
    private ArrayList<View.OnTouchListener> listeners = new ArrayList();

    public CompositeTouchListener addListener(@NotNull View.OnTouchListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public CompositeTouchListener addGestureDetector(@NotNull GestureDetector gestureDetector) {
        this.listeners.add(new GestureDetectorListener(gestureDetector));
        return this;
    }

    public CompositeTouchListener addScaleGestureDetector(@NotNull ScaleGestureDetector scaleGestureDetector) {
        this.listeners.add(new ScaleGestureDetectorListener(scaleGestureDetector));
        return this;
    }

    public boolean onTouch(View view, MotionEvent event) {
        boolean consumed = false;
        for (View.OnTouchListener listener : this.listeners) {
            consumed |= listener.onTouch(view, event);
        }
        return consumed;
    }

    static class ScaleGestureDetectorListener
    implements View.OnTouchListener {
        private final ScaleGestureDetector scaleGestureDetector;

        public ScaleGestureDetectorListener(ScaleGestureDetector scaleGestureDetector) {
            this.scaleGestureDetector = scaleGestureDetector;
        }

        public boolean onTouch(View view, MotionEvent event) {
            return this.scaleGestureDetector.onTouchEvent(event);
        }
    }

    static class GestureDetectorListener
    implements View.OnTouchListener {
        private final GestureDetector gestureDetector;

        public GestureDetectorListener(@NotNull GestureDetector gestureDetector) {
            this.gestureDetector = gestureDetector;
        }

        public boolean onTouch(View view, MotionEvent event) {
            return this.gestureDetector.onTouchEvent(event);
        }
    }
}

