package net.doo.snap.lib.snap.edit;

import com.google.inject.Inject;

import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.persistence.RotationType;
import net.doo.snap.lib.snap.preview.ImagePreviewFragment;
import net.doo.snap.lib.snap.PreviewFragmentPagerAdapter;
import net.doo.snap.lib.snap.edit.events.RotatePageEvent;
import net.doo.snap.lib.ui.widget.ViewPager;

import roboguice.event.Observes;

/**
 * Observes {@link net.doo.snap.lib.snap.edit.events.RotatePageEvent} and performs clockwise rotation
 * of current page.
 */
public class RotatePageEditor implements PagesEditor {

    private EditLock editLock;

    private ViewPager pager;
    private PreviewFragmentPagerAdapter adapter;

    @Inject
    public RotatePageEditor(EditLock editLock) {
        this.editLock = editLock;
    }

    @Override
    public void attachViewPager(ViewPager viewPager, PreviewFragmentPagerAdapter adapter) {
        this.pager = viewPager;
        this.adapter = adapter;
    }

    @SuppressWarnings("unused")
    public void onPageRotation(@Observes RotatePageEvent event) {
        if (editLock.isEditLocked()) {
            return;
        }

        final int currentItem = pager.getCurrentItem();

        ImagePreviewFragment fragment = adapter.getFragment(pager, currentItem);
        Page page = adapter.getDocumentDraft().getPage(currentItem);

        RotationType newRotation = RotationType.rotateClockwise(page.getRotationType());
        fragment.setPageRotation(newRotation);

        page.setRotationType(newRotation);
    }

}
