/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;
import com.google.zxing.client.result.ExpandedProductParsedResult;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ProductParsedResult;
import net.doo.snap.lib.snap.camera.barcode.result.ResultHandler;

public final class ProductResultHandler
extends ResultHandler {
    private static final int[] buttons = new int[]{2131230799, 2131230803};
    private static final int OPEN_PRODUCT_SEARCH = 0;
    private static final int WEB_SEARCH = 1;

    public ProductResultHandler(Activity activity, ParsedResult result) {
        super(activity, result);
    }

    @Override
    public int getButtonCount() {
        return buttons.length;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public void handleButtonPress(int index) {
        String productID = ProductResultHandler.getProductIDFromResult(this.getResult());
        switch (index) {
            case 0: {
                this.openProductSearch(productID);
                break;
            }
            case 1: {
                this.webSearch(productID);
            }
        }
    }

    private static String getProductIDFromResult(ParsedResult rawResult) {
        if (rawResult instanceof ProductParsedResult) {
            return ((ProductParsedResult)rawResult).getNormalizedProductID();
        }
        if (rawResult instanceof ExpandedProductParsedResult) {
            return ((ExpandedProductParsedResult)rawResult).getRawText();
        }
        throw new IllegalArgumentException(rawResult.getClass().toString());
    }

    @Override
    public String getDisplayTitle() {
        return ProductResultHandler.getProductIDFromResult(this.getResult());
    }

    @Override
    public String getDisplaySubtitle() {
        return null;
    }

    @Override
    public String getDisplayText() {
        return null;
    }

    @Override
    public int getDisplayIconRes() {
        return 2130837575;
    }
}

