/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.util;

import net.doo.snap.lib.util.State;

public class StateHolder {
    private State currentState;
    private State pendingState;

    public StateHolder() {
        this(State.DEFAULT);
    }

    public StateHolder(State currentState) throws NullPointerException {
        if (currentState == null) {
            throw new NullPointerException("State cannot be null");
        }
        this.currentState = currentState;
    }

    public void updateState(State newState) throws NullPointerException {
        if (newState == null) {
            throw new NullPointerException("State cannot be null");
        }
        if (this.currentState.equals(newState)) {
            return;
        }
        this.pendingState = newState;
        this.currentState.onLeave();
        newState.onEnter();
        this.currentState = newState;
        this.pendingState = null;
        State jumpTarget = newState.takeReferencedState();
        if (jumpTarget != null) {
            this.updateState(jumpTarget);
        }
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public State getPendingState() {
        return this.pendingState;
    }
}

