/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import net.doo.snap.lib.detector.DetectionResult;

public class AutoSnappingDetectionHelper {
    private Toast toast;
    private ImageView rotateDevice;
    private View moveCloser;
    private int orientation;

    public AutoSnappingDetectionHelper(Context context, View root) {
        this.toast = Toast.makeText((Context)context, (CharSequence)"", (int)0);
        this.toast.setGravity(17, 0, 0);
        this.orientation = context.getResources().getConfiguration().orientation;
        this.rotateDevice = (ImageView)root.findViewById(2131296300);
        this.moveCloser = root.findViewById(2131296318);
    }

    public void reset(boolean cancelToast) {
        this.rotateDevice.setVisibility(8);
        this.moveCloser.setVisibility(8);
        if (cancelToast) {
            this.toast.cancel();
        }
    }

    public void onResult(DetectionResult result) {
        this.reset(false);
        switch (result) {
            case OK_BUT_BAD_ASPECT_RATIO: {
                this.toast.cancel();
                int imageResource = 2130837560;
                switch (this.orientation) {
                    case 2: {
                        imageResource = 2130837561;
                    }
                }
                this.rotateDevice.setImageResource(imageResource);
                this.rotateDevice.setVisibility(0);
                break;
            }
            case OK_BUT_TOO_SMALL: {
                this.moveCloser.setVisibility(0);
                this.toast.setText(2131165242);
                this.toast.show();
                break;
            }
            case OK_BUT_BAD_ANGLES: {
                this.toast.setText(2131165243);
                this.toast.show();
                break;
            }
            case ERROR_NOTHING_DETECTED: {
                this.toast.setText(2131165244);
                this.toast.show();
                break;
            }
            case ERROR_TOO_NOISY: {
                this.toast.setText(2131165245);
                this.toast.show();
                break;
            }
            default: {
                this.toast.cancel();
            }
        }
    }
}

