/*
 * Decompiled with CFR 0.152.
 */
package com.ortiz.touch;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import android.widget.OverScroller;
import android.widget.Scroller;

public class TouchImageView
extends ImageView {
    private static final String DEBUG = "DEBUG";
    private static final float SUPER_MIN_MULTIPLIER = 1.0f;
    private static final float SUPER_MAX_MULTIPLIER = 1.25f;
    private float normalizedScale;
    private Matrix matrix;
    private Matrix prevMatrix;
    private State state;
    private float minScale;
    private float maxScale;
    private float superMinScale;
    private float superMaxScale;
    private float[] m;
    private Context context;
    private Fling fling;
    private ImageView.ScaleType mScaleType;
    private boolean imageRenderedAtLeastOnce;
    private boolean onDrawReady;
    private ZoomVariables delayedZoomVariables;
    private int viewWidth;
    private int viewHeight;
    private int prevViewWidth;
    private int prevViewHeight;
    private float matchViewWidth;
    private float matchViewHeight;
    private float prevMatchViewWidth;
    private float prevMatchViewHeight;
    private ScaleGestureDetector mScaleDetector;
    private GestureDetector mGestureDetector;
    private GestureDetector.OnDoubleTapListener doubleTapListener = null;
    private View.OnTouchListener userTouchListener = null;
    private OnTouchImageViewListener touchImageViewListener = null;

    public TouchImageView(Context context) {
        super(context);
        this.sharedConstructing(context);
    }

    public TouchImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.sharedConstructing(context);
    }

    public TouchImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.sharedConstructing(context);
    }

    private void sharedConstructing(Context context) {
        super.setClickable(true);
        this.context = context;
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureListener());
        this.matrix = new Matrix();
        this.prevMatrix = new Matrix();
        this.m = new float[9];
        this.normalizedScale = 1.0f;
        if (this.mScaleType == null) {
            this.mScaleType = ImageView.ScaleType.FIT_CENTER;
        }
        this.minScale = 1.0f;
        this.maxScale = 3.0f;
        this.superMinScale = 1.0f * this.minScale;
        this.superMaxScale = 1.25f * this.maxScale;
        this.setImageMatrix(this.matrix);
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.setState(State.NONE);
        this.onDrawReady = false;
        super.setOnTouchListener((View.OnTouchListener)new PrivateOnTouchListener());
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.userTouchListener = l;
    }

    public void setOnTouchImageViewListener(OnTouchImageViewListener l) {
        this.touchImageViewListener = l;
    }

    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener l) {
        this.doubleTapListener = l;
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.onImageSet();
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.onImageSet();
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        this.onImageSet();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.onImageSet();
    }

    private void onImageSet() {
        if (this.viewWidth == 0 || this.viewHeight == 0) {
            return;
        }
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setScaleType(ImageView.ScaleType type) {
        if (type == ImageView.ScaleType.FIT_START || type == ImageView.ScaleType.FIT_END) {
            throw new UnsupportedOperationException("TouchImageView does not support FIT_START or FIT_END");
        }
        if (type == ImageView.ScaleType.MATRIX) {
            super.setScaleType(ImageView.ScaleType.MATRIX);
        } else {
            this.mScaleType = type;
            if (this.onDrawReady) {
                this.setZoom(this);
            }
        }
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public boolean isZoomed() {
        return this.normalizedScale != 1.0f;
    }

    public RectF getZoomedRect() {
        if (this.mScaleType == ImageView.ScaleType.FIT_XY) {
            throw new UnsupportedOperationException("getZoomedRect() not supported with FIT_XY");
        }
        PointF topLeft = this.transformCoordTouchToBitmap(0.0f, 0.0f, true);
        PointF bottomRight = this.transformCoordTouchToBitmap(this.viewWidth, this.viewHeight, true);
        float w = this.getDrawable().getIntrinsicWidth();
        float h = this.getDrawable().getIntrinsicHeight();
        return new RectF(topLeft.x / w, topLeft.y / h, bottomRight.x / w, bottomRight.y / h);
    }

    private void savePreviousImageValues() {
        if (this.matrix != null && this.viewHeight != 0 && this.viewWidth != 0) {
            this.matrix.getValues(this.m);
            this.prevMatrix.setValues(this.m);
            this.prevMatchViewHeight = this.matchViewHeight;
            this.prevMatchViewWidth = this.matchViewWidth;
            this.prevViewHeight = this.viewHeight;
            this.prevViewWidth = this.viewWidth;
        }
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putFloat("saveScale", this.normalizedScale);
        bundle.putFloat("matchViewHeight", this.matchViewHeight);
        bundle.putFloat("matchViewWidth", this.matchViewWidth);
        bundle.putInt("viewWidth", this.viewWidth);
        bundle.putInt("viewHeight", this.viewHeight);
        this.matrix.getValues(this.m);
        bundle.putFloatArray("matrix", this.m);
        bundle.putBoolean("imageRendered", this.imageRenderedAtLeastOnce);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.normalizedScale = bundle.getFloat("saveScale");
            this.m = bundle.getFloatArray("matrix");
            this.prevMatrix.setValues(this.m);
            this.prevMatchViewHeight = bundle.getFloat("matchViewHeight");
            this.prevMatchViewWidth = bundle.getFloat("matchViewWidth");
            this.prevViewHeight = bundle.getInt("viewHeight");
            this.prevViewWidth = bundle.getInt("viewWidth");
            this.imageRenderedAtLeastOnce = bundle.getBoolean("imageRendered");
            super.onRestoreInstanceState(bundle.getParcelable("instanceState"));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    protected void onDraw(Canvas canvas) {
        this.onDrawReady = true;
        this.imageRenderedAtLeastOnce = true;
        if (this.delayedZoomVariables != null) {
            this.setZoom(this.delayedZoomVariables.scale, this.delayedZoomVariables.focusX, this.delayedZoomVariables.focusY, this.delayedZoomVariables.scaleType);
            this.delayedZoomVariables = null;
        }
        super.onDraw(canvas);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.savePreviousImageValues();
    }

    public float getMaxZoom() {
        return this.maxScale;
    }

    public void setMaxZoom(float max) {
        this.maxScale = max;
        this.superMaxScale = 1.25f * this.maxScale;
    }

    public float getMinZoom() {
        return this.minScale;
    }

    public float getZoom() {
        return this.normalizedScale;
    }

    public void setMinZoom(float min) {
        this.minScale = min;
        this.superMinScale = 1.0f * this.minScale;
    }

    public void resetZoom() {
        this.normalizedScale = 1.0f;
        this.fitImageToView();
    }

    public void setZoom(float scale) {
        this.setZoom(scale, 0.5f, 0.5f);
    }

    public void setZoom(float scale, float focusX, float focusY) {
        this.setZoom(scale, focusX, focusY, this.mScaleType);
    }

    public void setZoom(float scale, float focusX, float focusY, ImageView.ScaleType scaleType) {
        if (!this.onDrawReady) {
            this.delayedZoomVariables = new ZoomVariables(scale, focusX, focusY, scaleType);
            return;
        }
        if (scaleType != this.mScaleType) {
            this.setScaleType(scaleType);
        }
        this.resetZoom();
        this.scaleImage(scale, this.viewWidth / 2, this.viewHeight / 2, true);
        this.matrix.getValues(this.m);
        this.m[2] = -(focusX * this.getImageWidth() - (float)this.viewWidth * 0.5f);
        this.m[5] = -(focusY * this.getImageHeight() - (float)this.viewHeight * 0.5f);
        this.matrix.setValues(this.m);
        this.fixTrans();
        this.setImageMatrix(this.matrix);
    }

    public void setZoom(TouchImageView img) {
        PointF center = img.getScrollPosition();
        this.setZoom(img.getZoom(), center.x, center.y, img.getScaleType());
    }

    public void animateZoomTo(float scale) {
        this.animateZoomTo(scale, (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
    }

    public void animateZoomTo(float scale, float focusX, float focusY) {
        DoubleTapZoom doubleTapZoom = new DoubleTapZoom(scale, focusX, focusY, false);
        this.compatPostOnAnimation(doubleTapZoom);
    }

    public PointF getScrollPosition() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return null;
        }
        int drawableWidth = drawable2.getIntrinsicWidth();
        int drawableHeight = drawable2.getIntrinsicHeight();
        PointF point = this.transformCoordTouchToBitmap(this.viewWidth / 2, this.viewHeight / 2, true);
        point.x /= (float)drawableWidth;
        point.y /= (float)drawableHeight;
        return point;
    }

    public void setScrollPosition(float focusX, float focusY) {
        this.setZoom(this.normalizedScale, focusX, focusY);
    }

    private void fixTrans() {
        this.matrix.getValues(this.m);
        float transX = this.m[2];
        float transY = this.m[5];
        float fixTransX = this.getFixTrans(transX, this.viewWidth, this.getImageWidth());
        float fixTransY = this.getFixTrans(transY, this.viewHeight, this.getImageHeight());
        if (fixTransX != 0.0f || fixTransY != 0.0f) {
            this.matrix.postTranslate(fixTransX, fixTransY);
        }
    }

    private void fixScaleTrans() {
        this.fixTrans();
        this.matrix.getValues(this.m);
        if (this.getImageWidth() < (float)this.viewWidth) {
            this.m[2] = ((float)this.viewWidth - this.getImageWidth()) / 2.0f;
        }
        if (this.getImageHeight() < (float)this.viewHeight) {
            this.m[5] = ((float)this.viewHeight - this.getImageHeight()) / 2.0f;
        }
        this.matrix.setValues(this.m);
    }

    private float getFixTrans(float trans, float viewSize, float contentSize) {
        float maxTrans;
        float minTrans;
        if (contentSize <= viewSize) {
            minTrans = 0.0f;
            maxTrans = viewSize - contentSize;
        } else {
            minTrans = viewSize - contentSize;
            maxTrans = 0.0f;
        }
        if (trans < minTrans) {
            return -trans + minTrans;
        }
        if (trans > maxTrans) {
            return -trans + maxTrans;
        }
        return 0.0f;
    }

    private float getFixDragTrans(float delta, float viewSize, float contentSize) {
        if (contentSize <= viewSize) {
            return 0.0f;
        }
        return delta;
    }

    private float getImageWidth() {
        return this.matchViewWidth * this.normalizedScale;
    }

    private float getImageHeight() {
        return this.matchViewHeight * this.normalizedScale;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null || drawable2.getIntrinsicWidth() == 0 || drawable2.getIntrinsicHeight() == 0) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        int drawableWidth = drawable2.getIntrinsicWidth();
        int drawableHeight = drawable2.getIntrinsicHeight();
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        this.viewWidth = this.setViewSize(widthMode, widthSize, drawableWidth);
        this.viewHeight = this.setViewSize(heightMode, heightSize, drawableHeight);
        this.setMeasuredDimension(this.viewWidth, this.viewHeight);
        this.fitImageToView();
    }

    private void fitImageToView() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null || drawable2.getIntrinsicWidth() == 0 || drawable2.getIntrinsicHeight() == 0) {
            return;
        }
        if (this.matrix == null || this.prevMatrix == null) {
            return;
        }
        int drawableWidth = drawable2.getIntrinsicWidth();
        int drawableHeight = drawable2.getIntrinsicHeight();
        float scaleX = (float)this.viewWidth / (float)drawableWidth;
        float scaleY = (float)this.viewHeight / (float)drawableHeight;
        switch (this.mScaleType) {
            case CENTER: {
                scaleY = 1.0f;
                scaleX = 1.0f;
                break;
            }
            case CENTER_CROP: {
                scaleX = scaleY = Math.max(scaleX, scaleY);
                break;
            }
            case CENTER_INSIDE: {
                scaleX = scaleY = Math.min(1.0f, Math.min(scaleX, scaleY));
            }
            case FIT_CENTER: {
                scaleX = scaleY = Math.min(scaleX, scaleY);
                break;
            }
            case FIT_XY: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("TouchImageView does not support FIT_START or FIT_END");
            }
        }
        float redundantXSpace = (float)this.viewWidth - scaleX * (float)drawableWidth;
        float redundantYSpace = (float)this.viewHeight - scaleY * (float)drawableHeight;
        this.matchViewWidth = (float)this.viewWidth - redundantXSpace;
        this.matchViewHeight = (float)this.viewHeight - redundantYSpace;
        if (!this.isZoomed() && !this.imageRenderedAtLeastOnce) {
            this.matrix.setScale(scaleX, scaleY);
            this.matrix.postTranslate(redundantXSpace / 2.0f, redundantYSpace / 2.0f);
            this.normalizedScale = 1.0f;
        } else {
            if (this.prevMatchViewWidth == 0.0f || this.prevMatchViewHeight == 0.0f) {
                this.savePreviousImageValues();
            }
            this.prevMatrix.getValues(this.m);
            this.m[0] = this.matchViewWidth / (float)drawableWidth * this.normalizedScale;
            this.m[4] = this.matchViewHeight / (float)drawableHeight * this.normalizedScale;
            float transX = this.m[2];
            float transY = this.m[5];
            float prevActualWidth = this.prevMatchViewWidth * this.normalizedScale;
            float actualWidth = this.getImageWidth();
            this.translateMatrixAfterRotate(2, transX, prevActualWidth, actualWidth, this.prevViewWidth, this.viewWidth, drawableWidth);
            float prevActualHeight = this.prevMatchViewHeight * this.normalizedScale;
            float actualHeight = this.getImageHeight();
            this.translateMatrixAfterRotate(5, transY, prevActualHeight, actualHeight, this.prevViewHeight, this.viewHeight, drawableHeight);
            this.matrix.setValues(this.m);
        }
        this.fixTrans();
        this.setImageMatrix(this.matrix);
    }

    private int setViewSize(int mode, int size, int drawableWidth) {
        int viewSize;
        switch (mode) {
            case 0x40000000: {
                viewSize = size;
                break;
            }
            case -2147483648: {
                viewSize = Math.min(drawableWidth, size);
                break;
            }
            case 0: {
                viewSize = drawableWidth;
                break;
            }
            default: {
                viewSize = size;
            }
        }
        return viewSize;
    }

    private void translateMatrixAfterRotate(int axis, float trans, float prevImageSize, float imageSize, int prevViewSize, int viewSize, int drawableSize) {
        if (imageSize < (float)viewSize) {
            this.m[axis] = ((float)viewSize - (float)drawableSize * this.m[0]) * 0.5f;
        } else if (trans > 0.0f) {
            this.m[axis] = -((imageSize - (float)viewSize) * 0.5f);
        } else {
            float percentage = (Math.abs(trans) + 0.5f * (float)prevViewSize) / prevImageSize;
            this.m[axis] = -(percentage * imageSize - (float)viewSize * 0.5f);
        }
    }

    private void setState(State state) {
        this.state = state;
    }

    public boolean canScrollHorizontallyFroyo(int direction) {
        return this.canScrollHorizontally(direction);
    }

    public boolean canScrollHorizontally(int direction) {
        this.matrix.getValues(this.m);
        float x = this.m[2];
        if (this.getImageWidth() < (float)this.viewWidth) {
            return false;
        }
        if (x >= -1.0f && direction < 0) {
            return false;
        }
        return !(Math.abs(x) + (float)this.viewWidth + 1.0f >= this.getImageWidth()) || direction <= 0;
    }

    private void scaleImage(double deltaScale, float focusX, float focusY, boolean stretchImageToSuper) {
        float upperScale;
        float lowerScale;
        if (stretchImageToSuper) {
            lowerScale = this.superMinScale;
            upperScale = this.superMaxScale;
        } else {
            lowerScale = this.minScale;
            upperScale = this.maxScale;
        }
        float origScale = this.normalizedScale;
        this.normalizedScale = (float)((double)this.normalizedScale * deltaScale);
        if (this.normalizedScale > upperScale) {
            this.normalizedScale = upperScale;
            deltaScale = upperScale / origScale;
        } else if (this.normalizedScale < lowerScale) {
            this.normalizedScale = lowerScale;
            deltaScale = lowerScale / origScale;
        }
        this.matrix.postScale((float)deltaScale, (float)deltaScale, focusX, focusY);
        this.fixScaleTrans();
    }

    private PointF transformCoordTouchToBitmap(float x, float y, boolean clipToBitmap) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return new PointF();
        }
        this.matrix.getValues(this.m);
        float origW = drawable2.getIntrinsicWidth();
        float origH = drawable2.getIntrinsicHeight();
        float transX = this.m[2];
        float transY = this.m[5];
        float finalX = (x - transX) * origW / this.getImageWidth();
        float finalY = (y - transY) * origH / this.getImageHeight();
        if (clipToBitmap) {
            finalX = Math.min(Math.max(finalX, 0.0f), origW);
            finalY = Math.min(Math.max(finalY, 0.0f), origH);
        }
        return new PointF(finalX, finalY);
    }

    private PointF transformCoordBitmapToTouch(float bx, float by) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return new PointF();
        }
        this.matrix.getValues(this.m);
        float origW = drawable2.getIntrinsicWidth();
        float origH = drawable2.getIntrinsicHeight();
        float px = bx / origW;
        float py = by / origH;
        float finalX = this.m[2] + this.getImageWidth() * px;
        float finalY = this.m[5] + this.getImageHeight() * py;
        return new PointF(finalX, finalY);
    }

    @TargetApi(value=16)
    private void compatPostOnAnimation(Runnable runnable) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.postOnAnimation(runnable);
        } else {
            this.postDelayed(runnable, 16L);
        }
    }

    private void printMatrixInfo() {
        float[] n = new float[9];
        this.matrix.getValues(n);
        Log.d((String)DEBUG, (String)("Scale: " + n[0] + " TransX: " + n[2] + " TransY: " + n[5]));
    }

    private class ZoomVariables {
        public float scale;
        public float focusX;
        public float focusY;
        public ImageView.ScaleType scaleType;

        public ZoomVariables(float scale, float focusX, float focusY, ImageView.ScaleType scaleType) {
            this.scale = scale;
            this.focusX = focusX;
            this.focusY = focusY;
            this.scaleType = scaleType;
        }
    }

    @TargetApi(value=9)
    private class CompatScroller {
        Scroller scroller;
        OverScroller overScroller;
        boolean isPreGingerbread;

        public CompatScroller(Context context) {
            if (Build.VERSION.SDK_INT < 9) {
                this.isPreGingerbread = true;
                this.scroller = new Scroller(context);
            } else {
                this.isPreGingerbread = false;
                this.overScroller = new OverScroller(context);
            }
        }

        public void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
            if (this.isPreGingerbread) {
                this.scroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
            } else {
                this.overScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
            }
        }

        public void forceFinished(boolean finished) {
            if (this.isPreGingerbread) {
                this.scroller.forceFinished(finished);
            } else {
                this.overScroller.forceFinished(finished);
            }
        }

        public boolean isFinished() {
            if (this.isPreGingerbread) {
                return this.scroller.isFinished();
            }
            return this.overScroller.isFinished();
        }

        public boolean computeScrollOffset() {
            if (this.isPreGingerbread) {
                return this.scroller.computeScrollOffset();
            }
            this.overScroller.computeScrollOffset();
            return this.overScroller.computeScrollOffset();
        }

        public int getCurrX() {
            if (this.isPreGingerbread) {
                return this.scroller.getCurrX();
            }
            return this.overScroller.getCurrX();
        }

        public int getCurrY() {
            if (this.isPreGingerbread) {
                return this.scroller.getCurrY();
            }
            return this.overScroller.getCurrY();
        }
    }

    private class Fling
    implements Runnable {
        CompatScroller scroller;
        int currX;
        int currY;

        Fling(int velocityX, int velocityY) {
            int maxY;
            int minY;
            int maxX;
            int minX;
            TouchImageView.this.setState(State.FLING);
            this.scroller = new CompatScroller(TouchImageView.this.context);
            TouchImageView.this.matrix.getValues(TouchImageView.this.m);
            int startX = (int)TouchImageView.this.m[2];
            int startY = (int)TouchImageView.this.m[5];
            if (TouchImageView.this.getImageWidth() > (float)TouchImageView.this.viewWidth) {
                minX = TouchImageView.this.viewWidth - (int)TouchImageView.this.getImageWidth();
                maxX = 0;
            } else {
                minX = maxX = startX;
            }
            if (TouchImageView.this.getImageHeight() > (float)TouchImageView.this.viewHeight) {
                minY = TouchImageView.this.viewHeight - (int)TouchImageView.this.getImageHeight();
                maxY = 0;
            } else {
                minY = maxY = startY;
            }
            this.scroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
            this.currX = startX;
            this.currY = startY;
        }

        public void cancelFling() {
            if (this.scroller != null) {
                TouchImageView.this.setState(State.NONE);
                this.scroller.forceFinished(true);
            }
        }

        @Override
        public void run() {
            if (TouchImageView.this.touchImageViewListener != null) {
                TouchImageView.this.touchImageViewListener.onMove();
            }
            if (this.scroller.isFinished()) {
                this.scroller = null;
                return;
            }
            if (this.scroller.computeScrollOffset()) {
                int newX = this.scroller.getCurrX();
                int newY = this.scroller.getCurrY();
                int transX = newX - this.currX;
                int transY = newY - this.currY;
                this.currX = newX;
                this.currY = newY;
                TouchImageView.this.matrix.postTranslate((float)transX, (float)transY);
                TouchImageView.this.fixTrans();
                TouchImageView.this.setImageMatrix(TouchImageView.this.matrix);
                TouchImageView.this.compatPostOnAnimation(this);
            }
        }
    }

    private class DoubleTapZoom
    implements Runnable {
        private long startTime;
        private static final float ZOOM_TIME = 500.0f;
        private float startZoom;
        private float targetZoom;
        private float bitmapX;
        private float bitmapY;
        private boolean stretchImageToSuper;
        private AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();
        private PointF startTouch;
        private PointF endTouch;

        DoubleTapZoom(float targetZoom, float focusX, float focusY, boolean stretchImageToSuper) {
            TouchImageView.this.setState(State.ANIMATE_ZOOM);
            this.startTime = System.currentTimeMillis();
            this.startZoom = TouchImageView.this.normalizedScale;
            this.targetZoom = targetZoom;
            this.stretchImageToSuper = stretchImageToSuper;
            PointF bitmapPoint = TouchImageView.this.transformCoordTouchToBitmap(focusX, focusY, false);
            this.bitmapX = bitmapPoint.x;
            this.bitmapY = bitmapPoint.y;
            this.startTouch = TouchImageView.this.transformCoordBitmapToTouch(this.bitmapX, this.bitmapY);
            this.endTouch = new PointF((float)(TouchImageView.this.viewWidth / 2), (float)(TouchImageView.this.viewHeight / 2));
        }

        @Override
        public void run() {
            float t = this.interpolate();
            double deltaScale = this.calculateDeltaScale(t);
            TouchImageView.this.scaleImage(deltaScale, this.bitmapX, this.bitmapY, this.stretchImageToSuper);
            this.translateImageToCenterTouchPosition(t);
            TouchImageView.this.fixScaleTrans();
            TouchImageView.this.setImageMatrix(TouchImageView.this.matrix);
            if (TouchImageView.this.touchImageViewListener != null) {
                TouchImageView.this.touchImageViewListener.onMove();
            }
            if (t < 1.0f) {
                TouchImageView.this.compatPostOnAnimation(this);
            } else {
                TouchImageView.this.setState(State.NONE);
            }
        }

        private void translateImageToCenterTouchPosition(float t) {
            float targetX = this.startTouch.x + t * (this.endTouch.x - this.startTouch.x);
            float targetY = this.startTouch.y + t * (this.endTouch.y - this.startTouch.y);
            PointF curr = TouchImageView.this.transformCoordBitmapToTouch(this.bitmapX, this.bitmapY);
            TouchImageView.this.matrix.postTranslate(targetX - curr.x, targetY - curr.y);
        }

        private float interpolate() {
            long currTime = System.currentTimeMillis();
            float elapsed = (float)(currTime - this.startTime) / 500.0f;
            elapsed = Math.min(1.0f, elapsed);
            return this.interpolator.getInterpolation(elapsed);
        }

        private double calculateDeltaScale(float t) {
            double zoom = this.startZoom + t * (this.targetZoom - this.startZoom);
            return zoom / (double)TouchImageView.this.normalizedScale;
        }
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            TouchImageView.this.setState(State.ZOOM);
            return true;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            TouchImageView.this.scaleImage(detector.getScaleFactor(), detector.getFocusX(), detector.getFocusY(), true);
            if (TouchImageView.this.touchImageViewListener != null) {
                TouchImageView.this.touchImageViewListener.onMove();
            }
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            super.onScaleEnd(detector);
            TouchImageView.this.setState(State.NONE);
            boolean animateToZoomBoundary = false;
            float targetZoom = TouchImageView.this.normalizedScale;
            if (TouchImageView.this.normalizedScale > TouchImageView.this.maxScale) {
                targetZoom = TouchImageView.this.maxScale;
                animateToZoomBoundary = true;
            } else if (TouchImageView.this.normalizedScale < TouchImageView.this.minScale) {
                targetZoom = TouchImageView.this.minScale;
                animateToZoomBoundary = true;
            }
            if (animateToZoomBoundary) {
                DoubleTapZoom doubleTap = new DoubleTapZoom(targetZoom, TouchImageView.this.viewWidth / 2, TouchImageView.this.viewHeight / 2, true);
                TouchImageView.this.compatPostOnAnimation(doubleTap);
            }
        }
    }

    private class PrivateOnTouchListener
    implements View.OnTouchListener {
        private PointF last = new PointF();

        private PrivateOnTouchListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            if (TouchImageView.this.userTouchListener != null && TouchImageView.this.userTouchListener.onTouch(v, event)) {
                return true;
            }
            TouchImageView.this.mScaleDetector.onTouchEvent(event);
            TouchImageView.this.mGestureDetector.onTouchEvent(event);
            PointF curr = new PointF(event.getX(), event.getY());
            if (TouchImageView.this.state == State.NONE || TouchImageView.this.state == State.DRAG || TouchImageView.this.state == State.FLING) {
                switch (event.getAction()) {
                    case 0: {
                        this.last.set(curr);
                        if (TouchImageView.this.fling != null) {
                            TouchImageView.this.fling.cancelFling();
                        }
                        TouchImageView.this.setState(State.DRAG);
                        break;
                    }
                    case 2: {
                        if (TouchImageView.this.state != State.DRAG) break;
                        float deltaX = curr.x - this.last.x;
                        float deltaY = curr.y - this.last.y;
                        float fixTransX = TouchImageView.this.getFixDragTrans(deltaX, TouchImageView.this.viewWidth, TouchImageView.this.getImageWidth());
                        float fixTransY = TouchImageView.this.getFixDragTrans(deltaY, TouchImageView.this.viewHeight, TouchImageView.this.getImageHeight());
                        TouchImageView.this.matrix.postTranslate(fixTransX, fixTransY);
                        TouchImageView.this.fixTrans();
                        this.last.set(curr.x, curr.y);
                        break;
                    }
                    case 1: 
                    case 6: {
                        TouchImageView.this.setState(State.NONE);
                    }
                }
            }
            TouchImageView.this.setImageMatrix(TouchImageView.this.matrix);
            if (TouchImageView.this.touchImageViewListener != null) {
                TouchImageView.this.touchImageViewListener.onMove();
            }
            return true;
        }
    }

    public static interface OnTouchImageViewListener {
        public void onMove();
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (TouchImageView.this.doubleTapListener != null) {
                return TouchImageView.this.doubleTapListener.onSingleTapConfirmed(e);
            }
            return TouchImageView.this.performClick();
        }

        public void onLongPress(MotionEvent e) {
            TouchImageView.this.performLongClick();
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (TouchImageView.this.fling != null) {
                TouchImageView.this.fling.cancelFling();
            }
            TouchImageView.this.fling = new Fling((int)velocityX, (int)velocityY);
            TouchImageView.this.compatPostOnAnimation(TouchImageView.this.fling);
            return super.onFling(e1, e2, velocityX, velocityY);
        }

        public boolean onDoubleTap(MotionEvent e) {
            boolean consumed = false;
            if (TouchImageView.this.doubleTapListener != null) {
                consumed = TouchImageView.this.doubleTapListener.onDoubleTap(e);
            }
            if (!consumed && TouchImageView.this.state == State.NONE) {
                float targetZoom = TouchImageView.this.normalizedScale == TouchImageView.this.minScale ? TouchImageView.this.maxScale : TouchImageView.this.minScale;
                DoubleTapZoom doubleTap = new DoubleTapZoom(targetZoom, e.getX(), e.getY(), false);
                TouchImageView.this.compatPostOnAnimation(doubleTap);
                consumed = true;
            }
            return consumed;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            if (TouchImageView.this.doubleTapListener != null) {
                return TouchImageView.this.doubleTapListener.onDoubleTapEvent(e);
            }
            return false;
        }
    }

    private static enum State {
        NONE,
        DRAG,
        ZOOM,
        FLING,
        ANIMATE_ZOOM;

    }
}

