/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.edit;

import android.animation.Animator;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageView;
import com.google.inject.Inject;
import java.io.IOException;
import net.doo.snap.lib.persistence.OptimizationType;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.persistence.PageStoreStrategy;
import net.doo.snap.lib.persistence.RotationType;
import net.doo.snap.lib.snap.event.PageOptimizationTypeChangedEvent;
import net.doo.snap.lib.util.bitmap.PageBitmapLoader;
import net.doo.snap.lib.util.log.DebugLog;
import net.doo.snap.lib.util.ui.TransformableDrawable;
import net.doo.snap.lib.util.ui.ViewUtils;
import roboguice.event.EventManager;
import roboguice.fragment.RoboDialogFragment;

public class ChangeFilterFragment
extends RoboDialogFragment
implements LoaderManager.LoaderCallbacks<Bitmap> {
    private static final String ARG_PAGE = "ARG_PAGE";
    private static final String ARG_FILTER_BUTTON_BOUNDS = "ARG_FILTER_BUTTON_BOUNDS";
    private static final String ARG_FILTER_BUTTON_ID = "ARG_FILTER_BUTTON_ID";
    private static final String LOADER_IMAGE_PATH = "LOADER_IMAGE_PATH";
    private static final String ARG_VIEW_PAGER_ID = "ARG_VIEW_PAGER_ID";
    @Inject
    private PageStoreStrategy pageStoreStrategy;
    @Inject
    private EventManager eventManager;
    private Page page;
    private Rect filterButtonBounds;
    private int filterButtonId;
    private int viewPagerId;

    public static ChangeFilterFragment newInstance(Page page, View filterButton, int viewPagerId) {
        ChangeFilterFragment fragment = new ChangeFilterFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARG_PAGE, (Parcelable)page);
        args.putParcelable(ARG_FILTER_BUTTON_BOUNDS, (Parcelable)ViewUtils.getViewBounds(filterButton));
        args.putInt(ARG_FILTER_BUTTON_ID, filterButton.getId());
        args.putInt(ARG_VIEW_PAGER_ID, viewPagerId);
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        Bundle arguments = this.getArguments();
        this.page = (Page)arguments.getParcelable(ARG_PAGE);
        this.filterButtonBounds = (Rect)arguments.getParcelable(ARG_FILTER_BUTTON_BOUNDS);
        this.filterButtonId = arguments.getInt(ARG_FILTER_BUTTON_ID);
        this.viewPagerId = arguments.getInt(ARG_VIEW_PAGER_ID);
    }

    public void onCreate(Bundle savedInstanceState) {
        this.setStyle(2, 16974121);
        super.onCreate(savedInstanceState);
        this.runLoaders();
    }

    private void runLoaders() {
        try {
            for (OptimizationType optimizationType : OptimizationType.values()) {
                String path = this.pageStoreStrategy.getFilteredPreviewFile(this.page.getId(), optimizationType).getPath();
                Bundle args = new Bundle();
                args.putString(LOADER_IMAGE_PATH, path);
                this.getLoaderManager().initLoader(optimizationType.ordinal(), args, (LoaderManager.LoaderCallbacks)this);
            }
        }
        catch (IOException e) {
            DebugLog.logException(e);
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        Window window = dialog.getWindow();
        window.setBackgroundDrawableResource(17170445);
        window.clearFlags(2);
        return dialog;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        final View root = inflater.inflate(2130903049, container, false);
        ViewUtils.postOnPreDraw(root, new Runnable(){

            @Override
            public void run() {
                ChangeFilterFragment.this.initCloseButton(root);
            }
        });
        root.setAlpha(0.0f);
        root.animate().alpha(1.0f).setListener((Animator.AnimatorListener)new ViewUtils.HardwareLayerAnimationListener(root));
        return root;
    }

    private void initCloseButton(View root) {
        View closeButton = root.findViewById(2131296304);
        closeButton.setTranslationX((float)(this.filterButtonBounds.centerX() - closeButton.getWidth() / 2));
        closeButton.setTranslationY((float)(this.filterButtonBounds.top - closeButton.getHeight() / 2));
        closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ChangeFilterFragment.this.animateDismiss();
            }
        });
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        ViewUtils.postOnPreDraw(view, new Runnable(){

            @Override
            public void run() {
                ChangeFilterFragment.this.initPreviews();
            }
        });
    }

    private void initPreviews() {
        int[] position = new int[2];
        for (final OptimizationType optimizationType : OptimizationType.values()) {
            ImageView imageView = this.getImageViewForOptimizationType(optimizationType);
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (ChangeFilterFragment.this.page.getOptimizationType() != optimizationType) {
                        ChangeFilterFragment.this.eventManager.fire((Object)new PageOptimizationTypeChangedEvent(ChangeFilterFragment.this.page, optimizationType));
                    }
                    ChangeFilterFragment.this.animateDismiss();
                }
            });
            int startX = this.filterButtonBounds.centerX();
            int startY = this.filterButtonBounds.top;
            imageView.getLocationInWindow(position);
            imageView.setTranslationX((float)(startX - position[0]));
            imageView.setTranslationY((float)(startY - position[1]));
            imageView.setScaleX(0.2f);
            imageView.setScaleY(0.2f);
            imageView.setAlpha(0.3f);
        }
    }

    private void animateDismiss() {
        this.getView().animate().alpha(0.0f).setListener((Animator.AnimatorListener)new ViewUtils.HardwareLayerAnimationListener(this.getView()){

            @Override
            public void onAnimationFinished(Animator animator2) {
                if (!ChangeFilterFragment.this.isAdded()) {
                    return;
                }
                ChangeFilterFragment.this.dismissAllowingStateLoss();
            }
        });
        FragmentActivity activity = this.getActivity();
        activity.findViewById(this.filterButtonId).animate().alpha(1.0f);
        View pager = activity.findViewById(this.viewPagerId);
        pager.findViewById(this.viewPagerId).animate().alpha(1.0f).setListener((Animator.AnimatorListener)new ViewUtils.HardwareLayerAnimationListener(pager));
    }

    public void onResume() {
        super.onResume();
        FragmentActivity activity = this.getActivity();
        activity.findViewById(this.filterButtonId).animate().alpha(0.0f);
        View pager = activity.findViewById(this.viewPagerId);
        pager.animate().alpha(0.0f).setListener((Animator.AnimatorListener)new ViewUtils.HardwareLayerAnimationListener(pager));
    }

    public void onPause() {
        super.onPause();
        FragmentActivity activity = this.getActivity();
        activity.findViewById(this.filterButtonId).setAlpha(1.0f);
        activity.findViewById(this.viewPagerId).setAlpha(1.0f);
        this.dismissAllowingStateLoss();
    }

    public Loader<Bitmap> onCreateLoader(int id2, Bundle args) {
        String path = args.getString(LOADER_IMAGE_PATH);
        return new PageBitmapLoader((Context)this.getActivity(), path, null, null);
    }

    public void onLoadFinished(Loader<Bitmap> loader, final Bitmap data) {
        OptimizationType optimizationType = OptimizationType.values()[loader.getId()];
        final ImageView imageView = this.getImageViewForOptimizationType(optimizationType);
        imageView.setImageBitmap(data);
        ViewUtils.postOnPreDraw((View)imageView, new Runnable(){

            @Override
            public void run() {
                ChangeFilterFragment.this.applyResultAndStartAnimation(data, imageView);
            }
        });
    }

    private void applyResultAndStartAnimation(Bitmap data, ImageView imageView) {
        TransformableDrawable transformableDrawable = new TransformableDrawable((Drawable)new BitmapDrawable(this.getResources(), data));
        transformableDrawable.setRotation(this.page.getRotationType().getDegrees());
        transformableDrawable.setScale(this.calculateRotationScale(imageView, data, this.page.getRotationType()));
        imageView.setImageDrawable((Drawable)transformableDrawable);
        imageView.animate().alpha(1.0f).scaleX(1.0f).scaleY(1.0f).translationX(0.0f).translationY(0.0f).setListener((Animator.AnimatorListener)new ViewUtils.HardwareLayerAnimationListener((View)imageView));
    }

    public void onLoaderReset(Loader<Bitmap> loader) {
    }

    private float calculateRotationScale(ImageView imageView, Bitmap bitmap, RotationType rotationType) {
        if (bitmap == null) {
            DebugLog.d("No rotation scale - bitmap is null");
            return 1.0f;
        }
        float availableWidth = imageView.getWidth();
        float availableHeight = imageView.getHeight();
        if (rotationType == RotationType.ROTATION_0 || rotationType == RotationType.ROTATION_180 || rotationType == RotationType.ROTATION_360) {
            return Math.min(availableWidth / (float)bitmap.getWidth(), availableHeight / (float)bitmap.getHeight());
        }
        return Math.min(availableWidth / (float)bitmap.getHeight(), availableHeight / (float)bitmap.getWidth());
    }

    private ImageView getImageViewForOptimizationType(OptimizationType optimizationType) {
        View view;
        switch (optimizationType) {
            case NONE: {
                view = this.getView().findViewById(2131296305);
                break;
            }
            case COLOR_ENHANCED: {
                view = this.getView().findViewById(2131296306);
                break;
            }
            case GRAYSCALE: {
                view = this.getView().findViewById(2131296307);
                break;
            }
            case BLACK_AND_WHITE: {
                view = this.getView().findViewById(2131296308);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return (ImageView)view;
    }
}

