/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.persistence;

import android.graphics.Point;
import android.graphics.PointF;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.doo.snap.lib.persistence.Annotation;
import net.doo.snap.lib.persistence.OptimizationType;
import net.doo.snap.lib.persistence.RotationType;
import net.doo.snap.lib.persistence.Signature;
import org.jetbrains.annotations.NotNull;

public class Page
implements Parcelable {
    public static final String FILTERED_FOLDER = "filtered";
    private final String id;
    private final Bundle parameters;
    private OptimizationType optimizationType = OptimizationType.NONE;
    private RotationType rotationType = RotationType.ROTATION_0;
    private List<PointF> polygon = new ArrayList<PointF>(){
        {
            this.add(new PointF(0.0f, 0.0f));
            this.add(new PointF(1.0f, 0.0f));
            this.add(new PointF(1.0f, 1.0f));
            this.add(new PointF(0.0f, 1.0f));
        }
    };
    private SparseArray<Point> imageSizes = new SparseArray();
    private List<Signature> signatures = new ArrayList<Signature>();
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private boolean processed = false;
    public static Parcelable.Creator<Page> CREATOR = new Parcelable.Creator<Page>(){

        public Page createFromParcel(Parcel source) {
            return new Page(source);
        }

        public Page[] newArray(int size) {
            return new Page[size];
        }
    };

    Page() {
        this.id = UUID.randomUUID().toString();
        this.parameters = new Bundle();
    }

    public Page(String id2) {
        this.id = id2;
        this.parameters = new Bundle();
    }

    public String getId() {
        return this.id;
    }

    public OptimizationType getOptimizationType() {
        return this.optimizationType;
    }

    public void setOptimizationType(OptimizationType optimizationType) {
        this.optimizationType = optimizationType;
    }

    public RotationType getRotationType() {
        return this.rotationType;
    }

    public void setRotationType(RotationType rotationType) {
        this.rotationType = rotationType;
    }

    public List<PointF> getPolygon() {
        if (this.polygon == null) {
            return Collections.emptyList();
        }
        return this.polygon;
    }

    public void setPolygon(List<PointF> polygon) {
        if (polygon == null || polygon.size() != 4) {
            return;
        }
        this.polygon = polygon;
    }

    void setImageSize(ImageType imageType, int width, int height) {
        this.imageSizes.put(imageType.ordinal(), (Object)new Point(width, height));
    }

    public Point getImageSize(ImageType imageType) {
        return (Point)this.imageSizes.get(imageType.ordinal());
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public Bundle getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page page = (Page)o;
        return this.id.equals(page.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void addSignature(@NotNull Signature newSignature) {
        int index = this.signatures.indexOf(newSignature);
        if (index < 0) {
            this.signatures.add(newSignature);
        } else {
            this.signatures.set(index, newSignature);
        }
    }

    @NotNull
    public Signature getSignature(int position) {
        return this.signatures.get(position);
    }

    public Signature getSignature(String signatureId) {
        for (Signature signature : this.signatures) {
            if (!signature.getId().equals(signatureId)) continue;
            return signature;
        }
        return null;
    }

    public void removeSignature(@NotNull Signature signature) {
        this.signatures.remove(signature);
    }

    public void removeSignature(@NotNull String signatureId) {
        Iterator<Signature> iterator = this.signatures.iterator();
        while (iterator.hasNext()) {
            Signature signature = iterator.next();
            if (!signatureId.equals(signature.getId())) continue;
            iterator.remove();
        }
    }

    public int getSignaturesCount() {
        return this.signatures.size();
    }

    public void addAnnotation(Annotation annotation) {
        int index = this.annotations.indexOf(annotation);
        if (index < 0) {
            this.annotations.add(annotation);
        } else {
            this.annotations.set(index, annotation);
        }
    }

    public Annotation getAnnotation(int position) {
        return this.annotations.get(position);
    }

    public Annotation getAnnotation(String annotationId) {
        for (Annotation annotation : this.annotations) {
            if (!annotation.getId().equals(annotationId)) continue;
            return annotation;
        }
        return null;
    }

    public void removeAnnotation(Annotation annotation) {
        this.annotations.remove(annotation);
    }

    public int getAnnotationsCount() {
        return this.annotations.size();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeBundle(this.parameters);
        dest.writeInt(this.optimizationType == null ? -1 : this.optimizationType.ordinal());
        dest.writeInt(this.rotationType == null ? -1 : this.rotationType.ordinal());
        dest.writeTypedList(this.polygon);
        dest.writeSparseArray(this.imageSizes);
        dest.writeTypedList(this.signatures);
        dest.writeTypedList(this.annotations);
    }

    private Page(Parcel in) {
        this.id = in.readString();
        this.parameters = in.readBundle();
        int tmpOptimizationType = in.readInt();
        this.optimizationType = tmpOptimizationType == -1 ? null : OptimizationType.values()[tmpOptimizationType];
        int tmpRotationType = in.readInt();
        this.rotationType = tmpRotationType == -1 ? null : RotationType.values()[tmpRotationType];
        in.readTypedList(this.polygon, PointF.CREATOR);
        this.imageSizes = in.readSparseArray(SparseArray.class.getClassLoader());
        in.readTypedList(this.signatures, Signature.CREATOR);
        in.readTypedList(this.annotations, Annotation.CREATOR);
    }

    public static enum ImageType {
        ORGINAL("original"),
        PREVIEW("preview"),
        OPTIMIZED_PREVIEW("optimized_preview"),
        OPTIMIZED("optimized"),
        OVERLAY("overlay"),
        OVERLAY_TMP("overlay_tmp"),
        COMBINED("combined");

        private String fileName;

        private ImageType(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

