package net.doo.snap.lib.util.billing;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Represents an in-app product's listing details.
 */
public class SkuDetails {
    private String itemType;
    private String sku;
    private String type;
    private String price;
    private String title;
    private String description;
    private String json;

    public SkuDetails(String jsonSkuDetails) throws JSONException {
        this(IabHelper.ITEM_TYPE_INAPP, jsonSkuDetails);
    }

    public SkuDetails(String itemType, String jsonSkuDetails) throws JSONException {
        this.itemType = itemType;
        json = jsonSkuDetails;
        JSONObject jsonObject = new JSONObject(json);
        sku = jsonObject.optString("productId");
        type = jsonObject.optString("type");
        price = jsonObject.optString("price");
        title = jsonObject.optString("title");
        description = jsonObject.optString("description");
    }

    /**
     * @return item sku
     */
    public String getSku() {
        return sku;
    }

    /**
     * @return item type
     */
    public String getType() {
        return type;
    }

    /**
     * @return item price
     */
    public String getPrice() {
        return price;
    }

    /**
     * @return item title
     */
    public String getTitle() {
        return title;
    }

    /**
     * @return item description
     */
    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        return "SkuDetails:" + json;
    }
}
