/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.util.snap;

import android.hardware.Camera;
import android.os.Build;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Utils {
    private static final int A4_AREA = 8699840;
    private static final double ASPECT_TOLERANCE = 0.1;

    public static boolean isFlashSupported(Camera.Parameters parameters) {
        if (parameters == null) {
            return false;
        }
        List supportedFlashModes = parameters.getSupportedFlashModes();
        return supportedFlashModes != null && !supportedFlashModes.isEmpty() && (supportedFlashModes.size() != 1 || !((String)supportedFlashModes.get(0)).equals("off"));
    }

    public static Camera.Size getBestA4PictureSize(Camera.Parameters parameters) {
        TreeMap<Integer, Camera.Size> sizes = new TreeMap<Integer, Camera.Size>();
        for (Camera.Size size : parameters.getSupportedPictureSizes()) {
            int area = size.width * size.height;
            sizes.put(area, size);
        }
        Camera.Size result = null;
        Map.Entry entry = sizes.ceilingEntry(8699840);
        if (entry == null) {
            entry = sizes.floorEntry(8699840);
        }
        if (entry != null) {
            result = (Camera.Size)entry.getValue();
        }
        return result;
    }

    public static Camera.Size getLargestPictureSize(Camera.Parameters parameters) {
        Camera.Size result = null;
        for (Camera.Size size : parameters.getSupportedPictureSizes()) {
            if (result == null) {
                result = size;
                continue;
            }
            int newArea = size.width * size.height;
            int resultArea = result.width * result.height;
            if (newArea <= resultArea) continue;
            result = size;
        }
        return result;
    }

    public static Camera.Size getLargestSizeWithAspectRatioMatch(List<Camera.Size> sizes, double targetAspect) {
        SizeComparator comparator = new SizeComparator();
        ArrayList<Camera.Size> matchedPictureSizes = new ArrayList<Camera.Size>();
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            if (!(Math.abs(targetAspect - ratio) < 0.1)) continue;
            matchedPictureSizes.add(size);
        }
        return Collections.max(matchedPictureSizes, comparator);
    }

    public static Camera.Size findByWidthAndHeight(Camera.Parameters parameters, int width, int height) {
        for (Camera.Size size : parameters.getSupportedPictureSizes()) {
            if (size.width != width || size.height != height) continue;
            return size;
        }
        return null;
    }

    public static Camera.Size getBestAspectPictureSize(int displayOrientation, int width, int height, Camera.Parameters parameters, double closeEnough) {
        double targetRatio = (double)width / (double)height;
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        if (displayOrientation == 90 || displayOrientation == 270) {
            targetRatio = (double)height / (double)width;
        }
        List sizes = parameters.getSupportedPictureSizes();
        Collections.sort(sizes, Collections.reverseOrder(new SizeComparator()));
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            if (Math.abs(ratio - targetRatio) < minDiff) {
                optimalSize = size;
                minDiff = Math.abs(ratio - targetRatio);
            }
            if (!(minDiff < closeEnough)) continue;
            break;
        }
        return optimalSize;
    }

    public static void enableContinuousFocus(Camera.Parameters parameters) {
        if (parameters == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            List<String> focusModes = Utils.extractFocusModes(parameters);
            if (focusModes.contains("continuous-picture")) {
                parameters.setFocusMode("continuous-picture");
            } else if (focusModes.contains("auto")) {
                parameters.setFocusMode("auto");
            }
        }
    }

    public static void enableAutoFocus(Camera.Parameters parameters) {
        if (parameters == null) {
            return;
        }
        List<String> focusModes = Utils.extractFocusModes(parameters);
        if (focusModes.contains("auto") && !parameters.getFocusMode().equals("auto")) {
            parameters.setFocusMode("auto");
        }
    }

    private static List<String> extractFocusModes(Camera.Parameters parameters) {
        List<String> modes = parameters.getSupportedFocusModes();
        return modes != null ? modes : Collections.emptyList();
    }

    private static class SizeComparator
    implements Comparator<Camera.Size> {
        private SizeComparator() {
        }

        @Override
        public int compare(Camera.Size lhs, Camera.Size rhs) {
            int left = lhs.width * lhs.height;
            int right = rhs.width * rhs.height;
            return left - right;
        }
    }
}

