package net.doo.snap.lib.ui.tutorial;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import net.doo.snap.lib.PreferencesConstants;
import net.doo.snap.lib.R;

/**
 * Explains how to rearrange snapped pages
 */
public class RearrangementTutorialFragment extends OneTimeFragment {

    private View okButton;

    /**
     * @return new instance of {@link net.doo.snap.lib.ui.tutorial.RearrangementTutorialFragment}
     */
    public static RearrangementTutorialFragment newInstance() {
        return new RearrangementTutorialFragment();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        View rootView = inflater.inflate(R.layout.rearrangement_tutorial, container, false);

        okButton = rootView.findViewById(R.id.ok);

        return rootView;
    }

    @Override
    protected String getDialogId() {
        return PreferencesConstants.REARRANGEMENT_TUTORIAL;
    }

    @Override
    protected View getCancelView() {
        return okButton;
    }

}
