package net.doo.snap.lib.util.bitmap;

import android.app.ActivityManager;
import android.graphics.Bitmap;
import android.util.LruCache;

import com.google.inject.Inject;

/**
 * Cache for images. Key - path to the image.
 */
public class BitmapLruCache extends LruCache<String, Bitmap> {

    private static final int MEMORY_FRACTION_USED = 4;

    @Inject
    public BitmapLruCache(ActivityManager activityManager) {
        super((activityManager.getMemoryClass() * 1024 * 1024) / MEMORY_FRACTION_USED);
    }

    @Override
    protected int sizeOf(String key, Bitmap bitmap) {
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

}
