/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.widget.Toast;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.WifiParsedResult;
import net.doo.snap.lib.snap.camera.barcode.result.ResultHandler;
import net.doo.snap.lib.snap.camera.barcode.wifi.WifiConfigManager;
import net.doo.snap.lib.util.ThemesHelper;
import net.doo.snap.lib.util.log.DebugLog;

public final class WifiResultHandler
extends ResultHandler {
    private static final int CONNECT_TO_WIFI = 0;
    private final Activity parent;

    public WifiResultHandler(Activity activity, WifiParsedResult result) {
        super(activity, (ParsedResult)result);
        this.parent = activity;
    }

    public WifiParsedResult getResult() {
        return (WifiParsedResult)super.getResult();
    }

    @Override
    public int getButtonCount() {
        Object wifiManager = this.getActivity().getApplicationContext().getSystemService("wifi");
        if (wifiManager == null) {
            DebugLog.w("No WifiManager available from device");
            return 0;
        }
        return 1;
    }

    @Override
    public int getButtonText(int index) {
        return 2131165274;
    }

    @Override
    public void handleButtonPress(int index) {
        if (index == 0) {
            final Activity activity = this.getActivity();
            WifiManager wifiManager = (WifiManager)activity.getApplicationContext().getSystemService("wifi");
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)activity, (int)2131165275, (int)0).show();
                }
            });
            new WifiConfigManager(wifiManager).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new WifiParsedResult[]{this.getResult()});
            activity.onBackPressed();
        }
    }

    @Override
    public CharSequence getDisplayContents() {
        WifiParsedResult wifiResult = this.getResult();
        return wifiResult.getSsid() + " (" + wifiResult.getNetworkEncryption() + ')';
    }

    @Override
    public String getDisplayTitle() {
        WifiParsedResult wifiResult = this.getResult();
        return wifiResult.getSsid() + " (" + wifiResult.getNetworkEncryption() + ')';
    }

    @Override
    public String getDisplaySubtitle() {
        return this.getResult().getPassword();
    }

    @Override
    public String getDisplayText() {
        return null;
    }

    @Override
    public int getDisplayIconRes() {
        return ThemesHelper.getResourceId((Context)this.getActivity(), 2130772050);
    }
}

