/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.tutorial;

import android.app.Dialog;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import android.view.Window;
import com.google.inject.Inject;
import org.jetbrains.annotations.NotNull;
import roboguice.fragment.RoboDialogFragment;

public abstract class OneTimeFragment
extends RoboDialogFragment {
    private static final int FADE_IN_DURATION = 600;
    @Inject
    private SharedPreferences sharedPreferences;

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        Window window = dialog.getWindow();
        window.setBackgroundDrawableResource(2131230743);
        window.clearFlags(2);
        return dialog;
    }

    public void onCreate(Bundle savedInstanceState) {
        this.setStyle(2, 16974121);
        super.onCreate(savedInstanceState);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        View cancelView = this.getCancelView();
        if (cancelView != null) {
            this.getCancelView().setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    OneTimeFragment.this.consume();
                    OneTimeFragment.this.dismissAllowingStateLoss();
                }
            });
        }
        View decorView = this.getDialog().getWindow().getDecorView();
        decorView.setAlpha(0.0f);
        decorView.animate().alpha(1.0f).setDuration(600L);
    }

    protected void consume() {
        this.sharedPreferences.edit().putBoolean(this.getDialogId(), true).commit();
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        this.consume();
    }

    protected boolean shouldBeShown(String tutorialId, FragmentActivity activity, SharedPreferences sharedPreferences) {
        return !sharedPreferences.getBoolean(tutorialId, false) && activity.getSupportFragmentManager().findFragmentByTag(tutorialId) == null;
    }

    public final void showOnce(@NotNull FragmentActivity activity, @NotNull SharedPreferences sharedPreferences) {
        String tutorialId = this.getDialogId();
        if (!this.shouldBeShown(tutorialId, activity, sharedPreferences)) {
            return;
        }
        FragmentTransaction ft = activity.getSupportFragmentManager().beginTransaction();
        ft.add((Fragment)this, tutorialId);
        ft.commitAllowingStateLoss();
    }

    protected abstract String getDialogId();

    protected View getCancelView() {
        return null;
    }
}

