package net.doo.snap.lib.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.*;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import net.doo.snap.lib.R;
import net.doo.snap.lib.ui.widget.text.TypefaceProvider;
import net.doo.snap.lib.util.ThemesHelper;

import org.apache.commons.lang.StringUtils;

/**
 * Draws smart name term span
 */
public class TermSpanDrawable extends Drawable {

    private final Typeface typeface;
    private final Paint textPaint;
    private final String textToDraw;
    private float textX;
    private float textY;
    private final NinePatchDrawable bgDrawable;

    /**
     * @param context
     * @param text      which will be represented by this drawable
     */
    public TermSpanDrawable(Context context, String text) {
        if (text == null) {
            text = StringUtils.EMPTY;
        }

        Resources resources = context.getResources();
        typeface = new TypefaceProvider().getTypeface(context, resources.getString(R.string.FiraSans_Light));

        bgDrawable = (NinePatchDrawable) resources.getDrawable(ThemesHelper.getResourceId(context, R.attr.ui_settings_name_bg));

        textPaint = getTextPaint(resources);
        textToDraw = text;

        Rect textBounds = new Rect();
        textPaint.getTextBounds(textToDraw, 0, textToDraw.length(), textBounds);
        int height = resources.getDimensionPixelSize(R.dimen.smart_name_term_height);
        int padding = resources.getDimensionPixelSize(R.dimen.smart_name_term_padding);
        bgDrawable.setBounds(0, 0, textBounds.width() + padding * 2, height);
    }

    /**
     * @param resources
     * @return {@link android.graphics.Paint} which will be used for drawing text
     */
    protected Paint getTextPaint(Resources resources) {
        Paint paint = new Paint(Paint.ANTI_ALIAS_FLAG);
        paint.setColor(resources.getColor(android.R.color.white));
        paint.setTextSize(resources.getDimension(R.dimen.smart_name_term_text));
        paint.setTypeface(typeface);
        paint.setTextAlign(Paint.Align.CENTER);

        return paint;
    }

    @Override
    public void draw(Canvas canvas) {
        bgDrawable.draw(canvas);

        canvas.drawText(
                textToDraw,
                textX,
                textY,
                textPaint
        );
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);

        textX = bounds.width() / 2f;
        textY = bounds.height() * 0.7f;
    }

    @Override
    public int getIntrinsicWidth() {
        return bgDrawable.getBounds().width();
    }

    @Override
    public int getIntrinsicHeight() {
        //EditText crops 1px bottom line from ImageSpan, so we are adding 2px
        return bgDrawable.getBounds().height() + 2;
    }

    @Override
    public void setAlpha(int alpha) {
        //Not supported
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        //Not supported
    }

    @Override
    public int getOpacity() {
        return PixelFormat.TRANSLUCENT;
    }

}
