/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.util.snap;

import android.graphics.Matrix;
import android.graphics.PointF;
import java.util.ArrayList;
import java.util.List;
import net.doo.snap.lib.detector.Line2D;

public class PolygonHelper {
    private float[] tmpPoints = new float[8];
    private Matrix matrix = new Matrix();
    private int width;
    private int height;
    private int left;
    private int top;
    private int right;
    private int bottom;

    public void setRotation(int degrees) {
        this.matrix.setRotate((float)degrees, 0.5f, 0.5f);
    }

    public void setImageSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setLayout(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.width = right - left;
        this.height = bottom - top;
    }

    public void polygonToPoints(List<PointF> polygon, float[] points) {
        int i;
        for (i = 0; i < polygon.size(); ++i) {
            this.tmpPoints[i * 2] = polygon.get((int)i).x;
            this.tmpPoints[i * 2 + 1] = polygon.get((int)i).y;
        }
        this.matrix.mapPoints(this.tmpPoints);
        for (i = 0; i < polygon.size(); ++i) {
            points[i * 4] = (float)this.left + (float)this.width * this.tmpPoints[i * 2];
            points[i * 4 + 1] = (float)this.top + (float)this.height * this.tmpPoints[i * 2 + 1];
            points[i * 4 + 2] = (float)this.left + (float)this.width * this.tmpPoints[(i * 2 + 2) % 8];
            points[i * 4 + 3] = (float)this.top + (float)this.height * this.tmpPoints[(i * 2 + 3) % 8];
        }
    }

    public void getDrawingPolygon(List<PointF> polygon, List<PointF> drawingPolygon) {
        for (int i = 0; i < drawingPolygon.size(); ++i) {
            PointF point = polygon.get(i);
            PointF drawingPoint = drawingPolygon.get(i);
            drawingPoint.x = point.x * (float)this.width;
            drawingPoint.y = point.y * (float)this.height;
        }
    }

    public void getPolygonFromDrawingPolygon(List<PointF> drawingPolygon, List<PointF> polygon) {
        for (int i = 0; i < drawingPolygon.size(); ++i) {
            PointF point = polygon.get(i);
            PointF drawingPoint = drawingPolygon.get(i);
            point.x = drawingPoint.x / (float)this.width;
            point.y = drawingPoint.y / (float)this.height;
        }
    }

    public List<Line2D> scaleLines(List<Line2D> lines) {
        ArrayList<Line2D> outLines = new ArrayList<Line2D>();
        for (Line2D line : lines) {
            line.getStart().x = (float)this.left + (float)this.width * line.getStart().x;
            line.getStart().y = (float)this.top + (float)this.height * line.getStart().y;
            line.getEnd().x = (float)this.left + (float)this.width * line.getEnd().x;
            line.getEnd().y = (float)this.top + (float)this.height * line.getEnd().y;
            outLines.add(line);
        }
        return outLines;
    }
}

