package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;

import com.google.zxing.client.result.GeoParsedResult;

import net.doo.snap.lib.R;
import net.doo.snap.lib.util.ThemesHelper;

/**
 * Handles geographic coordinates (typically encoded as geo: URLs).
 */
public final class GeoResultHandler extends ResultHandler {
    private static final int[] buttons = {
            R.string.button_show_map,
            R.string.button_get_directions
    };
    private static final int OPEN_MAP = 0;
    private static final int NAVIGATE_TO = 1;

    public GeoResultHandler(Activity activity, GeoParsedResult result) {
        super(activity, result);
    }

    @Override
    public GeoParsedResult getResult() {
        return (GeoParsedResult) super.getResult();
    }

    @Override
    public int getButtonCount() {
        return buttons.length;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public void handleButtonPress(int index) {
        GeoParsedResult geoResult = getResult();
        switch (index) {
            case OPEN_MAP:
                openMap(geoResult.getGeoURI());
                break;
            case NAVIGATE_TO:
                getDirections(geoResult.getLatitude(), geoResult.getLongitude());
                break;
        }
    }

    @Override
    public String getDisplayTitle() {
        return null;
    }

    @Override
    public String getDisplaySubtitle() {
        return null;
    }

    @Override
    public String getDisplayText() {
        return getResult().getDisplayResult();
    }

    @Override
    public int getDisplayIconRes() {
        return ThemesHelper.getResourceId(getActivity(), R.attr.ui_qr_ico_map);
    }
}
