/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.smartname;

import android.app.Activity;
import android.content.Context;
import android.content.IntentSender;
import android.location.Address;
import android.location.Criteria;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.location.LocationClient;
import com.google.android.gms.location.LocationRequest;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.doo.snap.lib.smartname.TermType;
import net.doo.snap.lib.util.log.DebugLog;
import roboguice.activity.event.OnStartEvent;
import roboguice.activity.event.OnStopEvent;
import roboguice.event.Observes;

public class SmartNameValuesProvider
implements GooglePlayServicesClient.ConnectionCallbacks,
GooglePlayServicesClient.OnConnectionFailedListener {
    private static final int CONNECTION_FAILURE_RESOLUTION_REQUEST = 9000;
    private static final int LOCATION_UPDATE_FASTEST_INTERVAL_MILLIS = 1000;
    private static final int LOCATION_UPDATE_INTERVAL_MILLIS = 60000;
    private static final int MAX_RESULTS_COUNT = 1;
    private Activity activity;
    private String cityName;
    private Location location;
    private LocationClient locationClient;
    private LocationManager locationManager;
    private com.google.android.gms.location.LocationListener locationListener = new com.google.android.gms.location.LocationListener(){

        public void onLocationChanged(Location location) {
            SmartNameValuesProvider.this.location = location;
            SmartNameValuesProvider.this.updateCurrentCityName();
            SmartNameValuesProvider.this.disconnectPlayServices();
        }
    };
    private LocationListener androidLocationListener = new LocationListener(){

        public void onLocationChanged(Location location) {
            SmartNameValuesProvider.this.location = location;
            SmartNameValuesProvider.this.updateCurrentCityName();
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
        }
    };

    @Inject
    public SmartNameValuesProvider(Activity activity) {
        this.activity = activity;
        this.cityName = activity.getString(2131165297);
        if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity) != 0) {
            this.locationManager = (LocationManager)activity.getSystemService("location");
            Criteria criteria = new Criteria();
            criteria.setAccuracy(1);
            String provider = this.locationManager.getBestProvider(criteria, false);
            if (provider != null) {
                this.location = this.locationManager.getLastKnownLocation(provider);
            }
            if (this.location == null) {
                provider = this.locationManager.getBestProvider(criteria, true);
                if (provider != null) {
                    this.locationManager.requestSingleUpdate(provider, this.androidLocationListener, null);
                }
            } else {
                this.updateCurrentCityName();
            }
        }
        this.locationClient = new LocationClient((Context)activity, (GooglePlayServicesClient.ConnectionCallbacks)this, (GooglePlayServicesClient.OnConnectionFailedListener)this);
    }

    public void onStart(@Observes OnStartEvent event) {
        this.locationClient.connect();
    }

    public void onStop(@Observes OnStopEvent event) {
        if (this.locationManager != null) {
            this.locationManager.removeUpdates(this.androidLocationListener);
        }
        this.disconnectPlayServices();
    }

    private void disconnectPlayServices() {
        if (this.locationClient.isConnected()) {
            this.locationClient.removeLocationUpdates(this.locationListener);
        }
        this.locationClient.disconnect();
    }

    public String getTermValue(TermType termType) {
        switch (termType) {
            case CITY: {
                return TextUtils.isEmpty((CharSequence)this.cityName) ? this.activity.getString(2131165297) : this.cityName;
            }
            case YEAR: {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                return sdf.format(new Date());
            }
            case YEAR_SHORT: {
                SimpleDateFormat sdf = new SimpleDateFormat("yy");
                return sdf.format(new Date());
            }
            case MONTH: {
                SimpleDateFormat sdf = new SimpleDateFormat("MM");
                return sdf.format(new Date());
            }
            case DAY: {
                SimpleDateFormat sdf = new SimpleDateFormat("dd");
                return sdf.format(new Date());
            }
            case HOURS: {
                SimpleDateFormat sdf = new SimpleDateFormat("HH");
                return sdf.format(new Date());
            }
            case MINUTES: {
                SimpleDateFormat sdf = new SimpleDateFormat("mm");
                return sdf.format(new Date());
            }
            case SECONDS: {
                SimpleDateFormat sdf = new SimpleDateFormat("ss");
                return sdf.format(new Date());
            }
            case DEVICE_MODEL: {
                return TextUtils.isEmpty((CharSequence)Build.MODEL) ? "" : Build.MODEL;
            }
        }
        return "";
    }

    private void updateCurrentCityName() {
        new AsyncTask<Void, Void, String>(){

            protected String doInBackground(Void ... params) {
                String cityName = SmartNameValuesProvider.this.activity.getString(2131165297);
                if (SmartNameValuesProvider.this.location == null) {
                    return cityName;
                }
                Geocoder gcd = new Geocoder((Context)SmartNameValuesProvider.this.activity, Locale.getDefault());
                try {
                    List addresses = gcd.getFromLocation(SmartNameValuesProvider.this.location.getLatitude(), SmartNameValuesProvider.this.location.getLongitude(), 1);
                    if (addresses.size() > 0) {
                        cityName = ((Address)addresses.get(0)).getLocality();
                    }
                }
                catch (IOException e) {
                    DebugLog.logException(e);
                }
                return cityName;
            }

            protected void onPostExecute(String result) {
                SmartNameValuesProvider.this.cityName = result;
            }
        }.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, (Object[])new Void[0]);
    }

    public void onConnected(Bundle bundle) {
        DebugLog.d("GooglePlay service connected");
        this.location = this.locationClient.getLastLocation();
        this.updateCurrentCityName();
        this.requestLocationUpdates();
    }

    private void requestLocationUpdates() {
        LocationRequest request = LocationRequest.create();
        request.setPriority(102);
        request.setFastestInterval(1000L);
        request.setInterval(60000L);
        this.locationClient.requestLocationUpdates(request, this.locationListener);
    }

    public void onDisconnected() {
        DebugLog.d("GooglePlay service disconnected");
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            try {
                connectionResult.startResolutionForResult(this.activity, 9000);
            }
            catch (IntentSender.SendIntentException e) {
                DebugLog.logException(e);
            }
        } else {
            DebugLog.e("GooglePlay service connection failed: " + connectionResult.getErrorCode());
        }
    }
}

