/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.billing;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import com.amazon.device.iap.PurchasingListener;
import com.amazon.device.iap.PurchasingService;
import com.amazon.device.iap.model.Product;
import com.amazon.device.iap.model.ProductDataResponse;
import com.amazon.device.iap.model.PurchaseResponse;
import com.amazon.device.iap.model.PurchaseUpdatesResponse;
import com.amazon.device.iap.model.Receipt;
import com.amazon.device.iap.model.UserDataResponse;
import com.google.inject.Inject;
import java.util.HashSet;
import net.doo.snap.lib.billing.BillingConstants;
import net.doo.snap.lib.billing.BillingContent;
import net.doo.snap.lib.billing.BillingManager;
import net.doo.snap.lib.util.billing.IabHelper;
import net.doo.snap.lib.util.billing.IabResult;

public class AmazonBillingManagerImpl
implements BillingManager {
    private static final Handler MAIN_LOOPER_HANDLER = new Handler(Looper.getMainLooper());
    private boolean initialized = false;
    @Inject
    private SharedPreferences preferences;
    private BillingManager.RefreshItemsListener refreshItemsListener;
    private IabHelper.OnIabPurchaseFinishedListener purchaseFinishedListener;
    private IabHelper.OnIabSetupFinishedListener setupFinishedListener;
    private PurchasingListener purchasingListener = new PurchasingListener(){

        public void onUserDataResponse(UserDataResponse userDataResponse) {
        }

        public void onProductDataResponse(ProductDataResponse productDataResponse) {
            SharedPreferences.Editor editor = AmazonBillingManagerImpl.this.preferences.edit();
            for (String sku : productDataResponse.getProductData().keySet()) {
                Product product = (Product)productDataResponse.getProductData().get(sku);
                editor.putString("PRICE_" + sku, product.getPrice());
            }
            editor.apply();
            AmazonBillingManagerImpl.this.refreshItems();
        }

        public void onPurchaseResponse(PurchaseResponse purchaseResponse) {
            IabResult result = null;
            Receipt receipt = purchaseResponse.getReceipt();
            switch (purchaseResponse.getRequestStatus()) {
                case SUCCESSFUL: {
                    result = new IabResult(0, null);
                    if (receipt == null) break;
                    SharedPreferences.Editor editor = AmazonBillingManagerImpl.this.preferences.edit();
                    editor.putBoolean(receipt.getSku(), !receipt.isCanceled());
                    editor.apply();
                    break;
                }
                case ALREADY_PURCHASED: {
                    result = new IabResult(7, null);
                    if (receipt == null) break;
                    SharedPreferences.Editor editor = AmazonBillingManagerImpl.this.preferences.edit();
                    editor.putBoolean(receipt.getSku(), !receipt.isCanceled());
                    editor.apply();
                    break;
                }
                case FAILED: {
                    result = new IabResult(1, null);
                    break;
                }
                case INVALID_SKU: {
                    result = new IabResult(4, null);
                    break;
                }
                case NOT_SUPPORTED: {
                    result = new IabResult(3, null);
                }
            }
            if (AmazonBillingManagerImpl.this.purchaseFinishedListener != null) {
                AmazonBillingManagerImpl.this.purchaseFinishedListener.onIabPurchaseFinished(result, null);
            }
            AmazonBillingManagerImpl.this.purchaseFinishedListener = null;
        }

        public void onPurchaseUpdatesResponse(PurchaseUpdatesResponse purchaseUpdatesResponse) {
            for (String sku : BillingConstants.ALL_SKUS) {
                SharedPreferences.Editor editor = AmazonBillingManagerImpl.this.preferences.edit();
                editor.putBoolean(sku, false);
                editor.apply();
            }
            for (Receipt receipt : purchaseUpdatesResponse.getReceipts()) {
                SharedPreferences.Editor editor = AmazonBillingManagerImpl.this.preferences.edit();
                editor.putBoolean(receipt.getSku(), !receipt.isCanceled());
                editor.apply();
            }
            if (AmazonBillingManagerImpl.this.refreshItemsListener != null) {
                AmazonBillingManagerImpl.this.refreshItemsListener.onItemsRefreshFinished();
                AmazonBillingManagerImpl.this.refreshItemsListener = null;
            }
            AmazonBillingManagerImpl.this.notifySetupFinished();
        }
    };

    @Inject
    public AmazonBillingManagerImpl() {
    }

    @Override
    public void initialize(Context context, IabHelper.OnIabSetupFinishedListener listener) {
        PurchasingService.registerListener((Context)context, (PurchasingListener)this.purchasingListener);
        this.setupFinishedListener = listener;
        HashSet<String> skus = new HashSet<String>();
        for (String sku : BillingConstants.ALL_SKUS) {
            skus.add(sku);
        }
        PurchasingService.getProductData(skus);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isItemAvailable(String itemId) {
        return this.preferences.getBoolean(itemId, false);
    }

    @Override
    public boolean isBillingContentAvailable(BillingContent billingContent) {
        return BillingContent.isConentAvailable(billingContent, this);
    }

    @Override
    public String getItemPrice(String itemId) {
        return this.preferences.getString("PRICE_" + itemId, "");
    }

    @Override
    public void refreshItems() {
        PurchasingService.getPurchaseUpdates((boolean)true);
    }

    @Override
    public void refreshItemsAsync(BillingManager.RefreshItemsListener listener) {
        this.refreshItemsListener = listener;
        this.refreshItems();
    }

    @Override
    public void startBillingWorkflowForItem(Activity activity, String itemId, IabHelper.OnIabPurchaseFinishedListener listener) {
        this.purchaseFinishedListener = listener;
        PurchasingService.purchase((String)itemId);
    }

    @Override
    public boolean handleResult(int requestCode, int resultCode, Intent data) {
        return false;
    }

    @Override
    public void dispose() {
    }

    private void notifySetupFinished() {
        this.initialized = true;
        if (this.setupFinishedListener != null) {
            MAIN_LOOPER_HANDLER.post(new Runnable(){

                @Override
                public void run() {
                    AmazonBillingManagerImpl.this.setupFinishedListener.onIabSetupFinished(null);
                }
            });
        }
    }
}

