package net.doo.snap.lib.billing;

/**
 * Represents premium content items
 */
public enum BillingContent {
    PRO_PACK_CONTENT;

    /**
     * @param billingContent {@link net.doo.snap.lib.billing.BillingContent} billing content
     * @param billingManager {@link net.doo.snap.lib.billing.BillingManager} billing manager
     * @return {@code true} if purchase (not subscription!) content should be available, {@code false} - otherwise
     */
    public static boolean isPurchaseAvailable(BillingContent billingContent, BillingManager billingManager) {
        switch (billingContent) {
            case PRO_PACK_CONTENT:
                return !billingManager.isItemAvailable(BillingConstants.PRO_PACK_SKU)
                        && !billingManager.isItemAvailable(BillingConstants.PRO_PACK_DISCOUNT_1_SKU)
                        && !billingManager.isItemAvailable(BillingConstants.PRO_PACK_DISCOUNT_2_SKU);
            default:
                return false;
        }
    }

    /**
     * @see net.doo.snap.lib.billing.BillingManager#isBillingContentAvailable(BillingContent)
     */
    public static boolean isContentAvailable(BillingContent billingContent, BillingManager billingManager) {
        switch (billingContent) {
            case PRO_PACK_CONTENT:
                return billingManager.isItemAvailable(BillingConstants.PRO_PACK_SKU)
                        || billingManager.isItemAvailable(BillingConstants.PRO_PACK_DISCOUNT_1_SKU)
                        || billingManager.isItemAvailable(BillingConstants.PRO_PACK_DISCOUNT_2_SKU)
                        || billingManager.isItemAvailable(BillingConstants.PRO_PACK_SUBSCRIPTION_SKU);
            default:
                return false;
        }
    }
}
