package net.doo.snap.lib.analytics;

/**
 * Contains constants used for analytics
 */
public interface AnalyticsConst {

    /**
     * Used for UI events
     */
    String CATEGORY_UI = "ui";

    /**
     * Used when some UI controls are pressed
     */
    String ACTION_BUTTON_PRESS = "button_press";

    /**
     * Used when UI interaction lead to content change
     */
    String ACTION_CONTENT = "content";

    /**
     * Used when settings are changed
     */
    String ACTION_SETTINGS = "settings";

    /**
     * Used for license events
     */
    String CATEGORY_LICENSE = "license";

    /**
     * Used when unauthorized app use detected
     */
    String ACTION_UNAUTH_USE = "unauthorized_use";

    /**
     * Used when LICENSED callback received
     */
    String ACTION_GENUINE = "genuine";

    /**
     * Used when NOT_LICENSED callback received
     */
    String ACTION_NOT_GENUINE = "not_genuine";

    /**
     * Used for data events
     */
    String CATEGORY_DATA = "data";

    /**
     * Used when new document is created
     */
    String ACTION_DOCUMENT_CREATED = "document_created";

    /**
     * Used when document was edited and changes were applied
     */
    String ACTION_DOCUMENT_EDITED = "document_edited";

    /**
     * Used when ocr was started manually
     */
    String ACTION_OCR_STARTED = "ocr_started_manually";

    /**
     * Used for QR codes tracking
     */
    String ACTION_QR = "qr";

    /**
     * Token for event for Android application in Adjust tracking
     */
    String ADJUST_ANDROID_EVENT_TOKEN = "vgxgi4";

    /**
     * Billing category
     */
    String BILLING = "billing";

    /**
     * Billing event
     */
    String PURCHASE_RESULT = "purchase_result";

    /**
     * Performance of snapping
     */
    String TIMING_SNAPPING = "timing_snapping";

    /**
     * Used when theme was changed
     */
    String ACTION_THEMES = "themes";

}
