/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.util.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.DisplayMetrics;
import net.doo.snap.lib.util.bitmap.BitmapLruCache;
import net.doo.snap.lib.util.bitmap.BitmapUtils;
import net.doo.snap.lib.util.bitmap.PageBitmapLoader;

public class ScaledPageBitmapLoader
extends PageBitmapLoader {
    private DisplayMetrics displayMetrics;

    public ScaledPageBitmapLoader(Context context, String imagePath, BitmapLruCache bitmapLruCache, Bitmap preservedBitmap) {
        super(context, imagePath, bitmapLruCache, preservedBitmap);
        this.displayMetrics = context.getResources().getDisplayMetrics();
    }

    @Override
    public Bitmap loadInBackground() {
        if (this.imagePath != null) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapUtils.decodeQuietly(this.imagePath, options);
            options.inSampleSize = BitmapUtils.calculateInSampleSize(options, this.displayMetrics.widthPixels, this.displayMetrics.heightPixels);
            options.inJustDecodeBounds = false;
            return BitmapUtils.decodeQuietly(this.imagePath, options);
        }
        return null;
    }
}

