/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.widget.text;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.text.TextPaint;
import android.util.AttributeSet;
import net.doo.snap.lib.R;
import net.doo.snap.lib.ui.widget.text.CustomTypefaceTextView;

public class CircularTextView
extends CustomTypefaceTextView {
    public static final double THREE_FORTH_CIRCLE_INDEX = 1.5;
    private final float radius;

    public CircularTextView(Context context) {
        super(context);
        this.radius = 0.0f;
    }

    public CircularTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircularTextView);
        this.radius = a.getDimensionPixelSize(0, 0);
    }

    public CircularTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircularTextView);
        this.radius = a.getDimensionPixelSize(0, 0);
    }

    protected void onDraw(Canvas canvas) {
        TextPaint paint = this.getPaint();
        paint.setColor(this.getCurrentTextColor());
        paint.drawableState = this.getDrawableState();
        Path path = new Path();
        path.addCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2) + this.radius, this.radius, Path.Direction.CW);
        float textWidth = paint.measureText(this.getText().toString());
        double offset = Math.PI * (double)this.radius * 1.5 - (double)(textWidth / 2.0f);
        canvas.drawTextOnPath(this.getText().toString(), path, (float)offset, 0.0f, (Paint)paint);
    }
}

