package net.doo.snap.lib.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.LinearLayout;

/**
 * {@link android.widget.LinearLayout} which doesn't propagates {@link android.view.MotionEvent}s to
 * children if it's disabled
 */
public class NoDisabledTouchDispatchLinearLayout extends LinearLayout {

    public NoDisabledTouchDispatchLinearLayout(Context context) {
        super(context);
    }

    public NoDisabledTouchDispatchLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    public NoDisabledTouchDispatchLinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        return isEnabled() && super.dispatchTouchEvent(ev);
    }
}
