package net.doo.snap.lib.util;

/**
 * Opens market page for application
 */
public interface MarketPageOpener {

    /**
     * Opens market page for application or shows Toast if market is not installed
     */
    void openMarketPage();

    /**
     * Default implementation that does nothing
     */
    public static class Default implements MarketPageOpener {

        @Override
        public void openMarketPage() {
        }

    }

}
